/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.onosproject.net.DeviceId;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.Network;
import org.onosproject.tetopology.management.api.TeTopologyId;
import org.onosproject.tetopology.management.api.link.NetworkLink;
import org.onosproject.tetopology.management.api.node.NetworkNode;

public class DefaultNetwork
implements Network {
    private final KeyId networkId;
    private final List<KeyId> supportingNetworkIds;
    private final Map<KeyId, NetworkNode> nodes;
    private final Map<KeyId, NetworkLink> links;
    private final TeTopologyId teTopologyId;
    private final boolean serverProvided;
    private final DeviceId ownerId;

    public DefaultNetwork(KeyId networkId, List<KeyId> supportingNetworkIds, Map<KeyId, NetworkNode> nodes, Map<KeyId, NetworkLink> links, TeTopologyId teTopologyId, boolean serverProvided, DeviceId ownerId) {
        this.networkId = networkId;
        this.supportingNetworkIds = supportingNetworkIds != null ? Lists.newArrayList(supportingNetworkIds) : null;
        this.nodes = nodes != null ? Maps.newHashMap(nodes) : null;
        this.links = links != null ? Maps.newHashMap(links) : null;
        this.teTopologyId = teTopologyId;
        this.serverProvided = serverProvided;
        this.ownerId = ownerId;
    }

    @Override
    public KeyId networkId() {
        return this.networkId;
    }

    @Override
    public List<KeyId> supportingNetworkIds() {
        if (this.supportingNetworkIds == null) {
            return null;
        }
        return ImmutableList.copyOf(this.supportingNetworkIds);
    }

    @Override
    public Map<KeyId, NetworkNode> nodes() {
        if (this.nodes == null) {
            return null;
        }
        return ImmutableMap.copyOf(this.nodes);
    }

    @Override
    public NetworkNode node(KeyId nodeId) {
        return this.nodes.get(nodeId);
    }

    @Override
    public Map<KeyId, NetworkLink> links() {
        if (this.links == null) {
            return null;
        }
        return ImmutableMap.copyOf(this.links);
    }

    @Override
    public NetworkLink link(KeyId linkId) {
        return this.links.get(linkId);
    }

    @Override
    public boolean isServerProvided() {
        return this.serverProvided;
    }

    @Override
    public TeTopologyId teTopologyId() {
        return this.teTopologyId;
    }

    @Override
    public DeviceId ownerId() {
        return this.ownerId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.networkId, this.supportingNetworkIds, this.nodes, this.links, this.serverProvided, this.teTopologyId, this.ownerId});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DefaultNetwork) {
            DefaultNetwork that = (DefaultNetwork)object;
            return Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal(this.supportingNetworkIds, that.supportingNetworkIds) && Objects.equal(this.nodes, that.nodes) && Objects.equal(this.links, that.links) && Objects.equal((Object)this.serverProvided, (Object)that.serverProvided) && Objects.equal((Object)this.teTopologyId, (Object)that.teTopologyId) && Objects.equal((Object)this.ownerId, (Object)that.ownerId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("networkId", (Object)this.networkId).add("supportingNetworkIds", this.supportingNetworkIds).add("nodes", this.nodes).add("links", this.links).add("serverProvided", this.serverProvided).add("teTopologyId", (Object)this.teTopologyId).add("ownerId", (Object)this.ownerId).toString();
    }
}

