/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.BitSet;
import org.onosproject.net.DeviceId;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.OptimizationType;
import org.onosproject.tetopology.management.api.TeTopology;

public class CommonTopologyData {
    private final OptimizationType optimization;
    private final BitSet flags;
    private final KeyId networkId;
    private final DeviceId ownerId;

    public CommonTopologyData(KeyId networkId, OptimizationType optimization, BitSet flags, DeviceId ownerId) {
        this.optimization = optimization;
        this.flags = flags;
        this.networkId = networkId;
        this.ownerId = ownerId;
    }

    public CommonTopologyData(TeTopology teTopology) {
        this.optimization = teTopology.optimization();
        this.flags = teTopology.flags();
        this.networkId = teTopology.networkId();
        this.ownerId = teTopology.ownerId();
    }

    public OptimizationType optimization() {
        return this.optimization;
    }

    public KeyId networkId() {
        return this.networkId;
    }

    public BitSet flags() {
        return this.flags;
    }

    public DeviceId ownerId() {
        return this.ownerId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.optimization, this.flags, this.ownerId, this.networkId});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CommonTopologyData) {
            CommonTopologyData that = (CommonTopologyData)object;
            return Objects.equal((Object)((Object)this.optimization), (Object)((Object)that.optimization)) && Objects.equal((Object)this.flags, (Object)that.flags) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)this.ownerId, (Object)that.ownerId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("optimization", (Object)this.optimization).add("flags", (Object)this.flags).add("ownerId", (Object)this.ownerId).add("networkId", (Object)this.networkId).toString();
    }
}

