/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivermatrix;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverService;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverViewMessageHandler
extends UiMessageHandler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int ONE = 1;
    private static final String DRIVER_DATA_REQUEST = "driverDataRequest";
    private static final String DRIVER_DATA_RESPONSE = "driverDataResponse";
    private static final String DRIVERS = "drivers";
    private static final String BEHAVIOURS = "behaviours";
    private static final String MATRIX = "matrix";
    private static final Comparator<? super Class<? extends Behaviour>> BEHAVIOUR_BY_NAME = Comparator.comparing(Class::getSimpleName);
    private static final Comparator<? super Driver> DRIVER_BY_NAME = Comparator.comparing(Driver::name);

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new DataRequestHandler()));
    }

    private final class DataRequestHandler
    extends RequestHandler {
        private DataRequestHandler() {
            super(DriverViewMessageHandler.DRIVER_DATA_REQUEST);
        }

        public void process(ObjectNode payload) {
            DriverService driverService = (DriverService)this.get(DriverService.class);
            List<Driver> drivers = new ArrayList<Driver>(driverService.getDrivers());
            drivers = this.orderDrivers(drivers);
            List<Class<? extends Behaviour>> behaviours = this.orderBehaviours(drivers);
            this.sendMessage(DriverViewMessageHandler.DRIVER_DATA_RESPONSE, this.driversJson(drivers, behaviours));
        }

        private List<Driver> orderDrivers(List<Driver> drivers) {
            drivers.sort(DRIVER_BY_NAME);
            return drivers;
        }

        private List<Class<? extends Behaviour>> orderBehaviours(List<Driver> drivers) {
            HashSet allBehaviours = new HashSet();
            drivers.forEach(d -> allBehaviours.addAll(d.behaviours()));
            ArrayList<Class<? extends Behaviour>> ordered = new ArrayList<Class<? extends Behaviour>>(allBehaviours);
            ordered.sort(BEHAVIOUR_BY_NAME);
            return ordered;
        }

        private ObjectNode driversJson(List<Driver> drivers, List<Class<? extends Behaviour>> behaviours) {
            ObjectNode root = DriverViewMessageHandler.this.objectNode();
            this.addBehaviours(root, behaviours);
            this.addDrivers(root, drivers);
            this.addMatrixCells(root, drivers);
            return root;
        }

        private void addBehaviours(ObjectNode root, List<Class<? extends Behaviour>> behaviours) {
            ArrayNode array = DriverViewMessageHandler.this.arrayNode();
            root.set(DriverViewMessageHandler.BEHAVIOURS, (JsonNode)array);
            behaviours.forEach(b -> array.add(b.getSimpleName()));
        }

        private void addDrivers(ObjectNode root, List<Driver> drivers) {
            ArrayNode array = DriverViewMessageHandler.this.arrayNode();
            root.set(DriverViewMessageHandler.DRIVERS, (JsonNode)array);
            drivers.forEach(d -> array.add(d.name()));
        }

        private Set<Driver> findLineage(Driver driver) {
            ImmutableSet.Builder lineage = ImmutableSet.builder();
            lineage.add((Object)driver);
            List parents = driver.parents();
            if (parents != null) {
                parents.forEach(p -> lineage.addAll(this.findLineage((Driver)p)));
            }
            return lineage.build();
        }

        private void addMatrixCells(ObjectNode root, List<Driver> drivers) {
            ObjectNode matrix = DriverViewMessageHandler.this.objectNode();
            root.set(DriverViewMessageHandler.MATRIX, (JsonNode)matrix);
            drivers.forEach(driver -> {
                ObjectNode dnode = DriverViewMessageHandler.this.objectNode();
                matrix.set(driver.name(), (JsonNode)dnode);
                Set<Driver> lineage = this.findLineage((Driver)driver);
                lineage.forEach(d -> d.behaviours().forEach(b -> dnode.put(b.getSimpleName(), 1)));
            });
        }
    }
}

