/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.TreeMap;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.types.RouteDistinguisher;

public class VpnAdjRibIn {
    private Map<BgpNodeLSIdentifier, PathAttrNlriDetails> nodeTree = new TreeMap<BgpNodeLSIdentifier, PathAttrNlriDetails>();
    private Map<BgpLinkLSIdentifier, PathAttrNlriDetails> linkTree = new TreeMap<BgpLinkLSIdentifier, PathAttrNlriDetails>();
    private Map<BgpPrefixLSIdentifier, PathAttrNlriDetails> prefixTree = new TreeMap<BgpPrefixLSIdentifier, PathAttrNlriDetails>();
    private Map<RouteDistinguisher, Map<BgpNodeLSIdentifier, PathAttrNlriDetails>> vpnNodeTree = new TreeMap<RouteDistinguisher, Map<BgpNodeLSIdentifier, PathAttrNlriDetails>>();
    private Map<RouteDistinguisher, Map<BgpLinkLSIdentifier, PathAttrNlriDetails>> vpnLinkTree = new TreeMap<RouteDistinguisher, Map<BgpLinkLSIdentifier, PathAttrNlriDetails>>();
    private Map<RouteDistinguisher, Map<BgpPrefixLSIdentifier, PathAttrNlriDetails>> vpnPrefixTree = new TreeMap<RouteDistinguisher, Map<BgpPrefixLSIdentifier, PathAttrNlriDetails>>();

    public Map<BgpNodeLSIdentifier, PathAttrNlriDetails> nodeTree() {
        return this.nodeTree;
    }

    public Map<BgpLinkLSIdentifier, PathAttrNlriDetails> linkTree() {
        return this.linkTree;
    }

    public Map<BgpPrefixLSIdentifier, PathAttrNlriDetails> prefixTree() {
        return this.prefixTree;
    }

    public Map<RouteDistinguisher, Map<BgpNodeLSIdentifier, PathAttrNlriDetails>> vpnNodeTree() {
        return this.vpnNodeTree;
    }

    public Map<RouteDistinguisher, Map<BgpLinkLSIdentifier, PathAttrNlriDetails>> vpnLinkTree() {
        return this.vpnLinkTree;
    }

    public Map<RouteDistinguisher, Map<BgpPrefixLSIdentifier, PathAttrNlriDetails>> vpnPrefixTree() {
        return this.vpnPrefixTree;
    }

    public void add(BgpLSNlri nlri, PathAttrNlriDetails details) {
        if (nlri instanceof BgpNodeLSNlriVer4) {
            BgpNodeLSIdentifier nodeLSIdentifier = ((BgpNodeLSNlriVer4)nlri).getLocalNodeDescriptors();
            if (this.nodeTree.containsKey(nodeLSIdentifier)) {
                this.nodeTree.replace(nodeLSIdentifier, details);
            } else {
                this.nodeTree.put(nodeLSIdentifier, details);
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            BgpLinkLSIdentifier linkLSIdentifier = ((BgpLinkLsNlriVer4)nlri).getLinkIdentifier();
            if (this.linkTree.containsKey(linkLSIdentifier)) {
                this.linkTree.replace(linkLSIdentifier, details);
            } else {
                this.linkTree.put(linkLSIdentifier, details);
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4) {
            BgpPrefixLSIdentifier prefixIdentifier = ((BgpPrefixIPv4LSNlriVer4)nlri).getPrefixIdentifier();
            if (this.prefixTree.containsKey(prefixIdentifier)) {
                this.prefixTree.replace(prefixIdentifier, details);
            } else {
                this.prefixTree.put(prefixIdentifier, details);
            }
        }
    }

    public void addVpn(BgpLSNlri nlri, PathAttrNlriDetails details, RouteDistinguisher routeDistinguisher) {
        this.add(nlri, details);
        if (nlri instanceof BgpNodeLSNlriVer4) {
            if (!this.vpnNodeTree.containsKey(routeDistinguisher)) {
                this.vpnNodeTree.put(routeDistinguisher, this.nodeTree);
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            if (!this.vpnLinkTree.containsKey(routeDistinguisher)) {
                this.vpnLinkTree.put(routeDistinguisher, this.linkTree);
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4 && !this.vpnPrefixTree.containsKey(routeDistinguisher)) {
            this.vpnPrefixTree.put(routeDistinguisher, this.prefixTree);
        }
    }

    public void removeVpn(BgpLSNlri nlri, RouteDistinguisher routeDistinguisher) {
        if (nlri instanceof BgpNodeLSNlriVer4) {
            if (this.vpnNodeTree.containsKey(routeDistinguisher)) {
                BgpNodeLSIdentifier nodeLSIdentifier = ((BgpNodeLSNlriVer4)nlri).getLocalNodeDescriptors();
                if (this.nodeTree.containsKey(nodeLSIdentifier)) {
                    this.nodeTree.remove(nodeLSIdentifier);
                }
                if (this.vpnNodeTree.get(routeDistinguisher).isEmpty()) {
                    this.vpnNodeTree.remove(routeDistinguisher);
                }
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            if (this.vpnLinkTree.containsKey(routeDistinguisher)) {
                BgpLinkLSIdentifier linkLSIdentifier = ((BgpLinkLsNlriVer4)nlri).getLinkIdentifier();
                if (this.linkTree.containsKey(linkLSIdentifier)) {
                    this.linkTree.remove(linkLSIdentifier);
                }
                if (this.vpnLinkTree.get(routeDistinguisher).isEmpty()) {
                    this.vpnLinkTree.remove(routeDistinguisher);
                }
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4 && this.vpnPrefixTree.containsKey(routeDistinguisher)) {
            BgpPrefixLSIdentifier prefixIdentifier = ((BgpPrefixIPv4LSNlriVer4)nlri).getPrefixIdentifier();
            if (this.prefixTree.containsKey(prefixIdentifier)) {
                this.prefixTree.remove(prefixIdentifier);
            }
            if (this.vpnPrefixTree.get(routeDistinguisher).isEmpty()) {
                this.vpnPrefixTree.remove(routeDistinguisher);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("nodeTree", this.nodeTree).add("linkTree", this.linkTree).add("prefixTree", this.prefixTree).add("vpnNodeTree", this.vpnNodeTree).add("vpnLinkTree", this.vpnLinkTree).add("vpnPrefixTree", this.vpnPrefixTree).toString();
    }
}

