/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetailsLocalRib;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.LocalPref;
import org.onosproject.bgpio.types.Med;
import org.onosproject.bgpio.types.Origin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpSelectionAlgo
implements Comparator<PathAttrNlriDetailsLocalRib> {
    private static final Logger log = LoggerFactory.getLogger(BgpSelectionAlgo.class);
    LocalPref obj1LocPref = null;
    AsPath obj1Aspath = null;
    Origin obj1Origin = null;
    Med obj1Med = null;
    LocalPref obj2LocPref = null;
    AsPath obj2Aspath = null;
    Origin obj2Origin = null;
    Med obj2Med = null;

    @Override
    public int compare(PathAttrNlriDetailsLocalRib pathNlriDetails1, PathAttrNlriDetailsLocalRib pathNlriDetails2) {
        Integer obj2Size;
        Integer obj1Size;
        if (pathNlriDetails1 == null) {
            return -1;
        }
        if (pathNlriDetails2 == null) {
            return 1;
        }
        if (pathNlriDetails1.equals((Object)pathNlriDetails2)) {
            return 0;
        }
        List o1 = pathNlriDetails1.localRibNlridetails().pathAttributes();
        List o2 = pathNlriDetails2.localRibNlridetails().pathAttributes();
        ListIterator<BgpValueType> listIteratorObj1 = o1.listIterator();
        ListIterator<BgpValueType> listIteratorObj2 = o2.listIterator();
        this.storeAttr(listIteratorObj1, listIteratorObj2);
        if (this.obj1LocPref != null || this.obj2LocPref != null && this.obj1LocPref != null && !this.obj1LocPref.equals((Object)this.obj2LocPref)) {
            return this.compareLocalPref(this.obj1LocPref, this.obj2LocPref);
        }
        if (!this.obj1Aspath.equals((Object)this.obj2Aspath) && !(obj1Size = this.countASSize(this.obj1Aspath)).equals(obj2Size = this.countASSize(this.obj2Aspath))) {
            return this.compareAsPath(obj1Size, obj2Size);
        }
        if (!this.obj1Origin.equals((Object)this.obj2Origin)) {
            return this.compareOrigin(this.obj1Origin, this.obj2Origin);
        }
        if (this.obj1Med != null || this.obj2Med != null && this.obj1Med != null && !this.obj1Med.equals((Object)this.obj2Med)) {
            return this.compareMed(this.obj1Med, this.obj2Med);
        }
        if (!pathNlriDetails1.equals((Object)pathNlriDetails2)) {
            return this.comparePeerDetails(pathNlriDetails1, pathNlriDetails2);
        }
        return 0;
    }

    int compareLocalPref(LocalPref obj1LocPref, LocalPref obj2LocPref) {
        return Integer.valueOf(obj1LocPref.localPref()).compareTo(obj2LocPref.localPref());
    }

    int compareAsPath(Integer obj1Size, Integer obj2Size) {
        return obj1Size.compareTo(obj2Size);
    }

    int compareOrigin(Origin obj1Origin, Origin obj2Origin) {
        if (obj1Origin.origin() == Origin.OriginType.IGP) {
            return 1;
        }
        if (obj2Origin.origin() == Origin.OriginType.IGP) {
            return -1;
        }
        if (obj1Origin.origin() == Origin.OriginType.EGP) {
            return 1;
        }
        return -1;
    }

    int compareMed(Med obj1Med, Med obj2Med) {
        return Integer.valueOf(obj2Med.med()).compareTo(obj1Med.med());
    }

    int comparePeerDetails(PathAttrNlriDetailsLocalRib pathNlriDetails1, PathAttrNlriDetailsLocalRib pathNlriDetails2) {
        if (pathNlriDetails1.isLocalRibIbgpSession() != pathNlriDetails2.isLocalRibIbgpSession()) {
            if (pathNlriDetails1.isLocalRibIbgpSession()) {
                return -1;
            }
            if (pathNlriDetails2.isLocalRibIbgpSession()) {
                return 1;
            }
        }
        if (pathNlriDetails1.localRibIdentifier() != pathNlriDetails2.localRibIdentifier()) {
            return Integer.valueOf(pathNlriDetails2.localRibIdentifier()).compareTo(pathNlriDetails1.localRibIdentifier());
        }
        if (pathNlriDetails1.localRibIpAddress() != pathNlriDetails2.localRibIpAddress()) {
            return pathNlriDetails2.localRibIpAddress().compareTo(pathNlriDetails1.localRibIpAddress());
        }
        return 0;
    }

    Integer countASSize(AsPath aspath) {
        boolean isASSet = false;
        int count = 0;
        if (!aspath.asPathSet().isEmpty()) {
            isASSet = true;
        }
        if (!aspath.asPathSeq().isEmpty()) {
            count = aspath.asPathSeq().size();
        }
        return isASSet ? ++count : count;
    }

    void storeAttr(ListIterator<BgpValueType> listIteratorObj1, ListIterator<BgpValueType> listIteratorObj2) {
        block12: while (listIteratorObj1.hasNext()) {
            BgpValueType pathAttributeObj1 = listIteratorObj1.next();
            switch (pathAttributeObj1.getType()) {
                case 5: {
                    this.obj1LocPref = (LocalPref)pathAttributeObj1;
                    continue block12;
                }
                case 2: {
                    this.obj1Aspath = (AsPath)pathAttributeObj1;
                    continue block12;
                }
                case 1: {
                    this.obj1Origin = (Origin)pathAttributeObj1;
                    continue block12;
                }
                case 4: {
                    this.obj1Med = (Med)pathAttributeObj1;
                    continue block12;
                }
            }
            log.debug("Got other type, Not required: " + pathAttributeObj1.getType());
        }
        block13: while (listIteratorObj2.hasNext()) {
            BgpValueType pathAttributeObj2 = listIteratorObj2.next();
            switch (pathAttributeObj2.getType()) {
                case 5: {
                    this.obj2LocPref = (LocalPref)pathAttributeObj2;
                    continue block13;
                }
                case 2: {
                    this.obj2Aspath = (AsPath)pathAttributeObj2;
                    continue block13;
                }
                case 1: {
                    this.obj2Origin = (Origin)pathAttributeObj2;
                    continue block13;
                }
                case 4: {
                    this.obj2Med = (Med)pathAttributeObj2;
                    continue block13;
                }
            }
            log.debug("Got other type, Not required: " + pathAttributeObj2.getType());
        }
    }
}

