/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.netty.channel.Channel;
import org.onlab.packet.IpAddress;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpLocalRib;
import org.onosproject.bgp.controller.BgpPeer;
import org.onosproject.bgp.controller.BgpSessionInfo;
import org.onosproject.bgp.controller.impl.AdjRibIn;
import org.onosproject.bgp.controller.impl.BgpLocalRibImpl;
import org.onosproject.bgp.controller.impl.BgpPacketStatsImpl;
import org.onosproject.bgp.controller.impl.Controller;
import org.onosproject.bgp.controller.impl.VpnAdjRibIn;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpFactory;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpUpdateMsg;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecNlri;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecRouteKey;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.types.As4Path;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.BgpExtendedCommunity;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.LocalPref;
import org.onosproject.bgpio.types.Med;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.MpUnReachNlri;
import org.onosproject.bgpio.types.MultiProtocolExtnCapabilityTlv;
import org.onosproject.bgpio.types.Origin;
import org.onosproject.bgpio.types.RpdCapabilityTlv;
import org.onosproject.bgpio.types.attr.WideCommunity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPeerImpl
implements BgpPeer {
    protected final Logger log = LoggerFactory.getLogger(BgpPeerImpl.class);
    private static final String SHUTDOWN_MSG = "Worker has already been shutdown";
    private BgpController bgpController;
    private Channel channel;
    protected String channelId;
    private boolean connected;
    protected boolean isHandShakeComplete = false;
    private BgpSessionInfo sessionInfo;
    private BgpPacketStatsImpl pktStats;
    private BgpLocalRib bgplocalRib;
    private BgpLocalRib bgplocalRibVpn;
    private AdjRibIn adjRib;
    private VpnAdjRibIn vpnAdjRib;

    public AdjRibIn adjacencyRib() {
        return this.adjRib;
    }

    public VpnAdjRibIn vpnAdjacencyRib() {
        return this.vpnAdjRib;
    }

    public BgpSessionInfo sessionInfo() {
        return this.sessionInfo;
    }

    public BgpPeerImpl(BgpController bgpController, BgpSessionInfo sessionInfo, BgpPacketStatsImpl pktStats) {
        this.bgpController = bgpController;
        this.sessionInfo = sessionInfo;
        this.pktStats = pktStats;
        this.bgplocalRib = bgpController.bgpLocalRib();
        this.bgplocalRibVpn = bgpController.bgpLocalRibVpn();
        this.adjRib = new AdjRibIn();
        this.vpnAdjRib = new VpnAdjRibIn();
    }

    public final boolean isCapabilitySupported(short type, short afi, byte sAfi) {
        List capability = this.sessionInfo.remoteBgpCapability();
        ListIterator listIterator = capability.listIterator();
        while (listIterator.hasNext()) {
            MultiProtocolExtnCapabilityTlv temp;
            BgpValueType tlv = (BgpValueType)listIterator.next();
            if (tlv.getType() != type) continue;
            if (tlv.getType() == 1) {
                temp = (MultiProtocolExtnCapabilityTlv)tlv;
                if (temp.getAfi() != afi || temp.getSafi() != sAfi) continue;
                this.log.debug("Multi prorotcol extension capabality TLV is true");
                return true;
            }
            if (tlv.getType() != -127 || (temp = (RpdCapabilityTlv)tlv).getAfi() != afi || temp.getSafi() != sAfi) continue;
            this.log.debug("RPD capabality TLV is true");
            return true;
        }
        this.log.debug("IS capabality is not supported ");
        return false;
    }

    public final void sendFlowSpecUpdateMessageToPeer(BgpPeer.FlowSpecOperation operType, BgpFlowSpecRouteKey routeKey, BgpFlowSpecNlri flowSpec, WideCommunity wideCommunity) {
        LinkedList<Object> attributesList = new LinkedList<Object>();
        boolean sessionType = !this.sessionInfo.isIbgpSession();
        byte sAfi = -123;
        boolean isFsCapabilitySet = this.isCapabilitySupported((short)1, (short)1, (byte)-123);
        boolean isVpnFsCapabilitySet = this.isCapabilitySupported((short)1, (short)1, (byte)-122);
        boolean isRpdCapabilitySet = this.isCapabilitySupported((short)-127, (short)1, (byte)-123);
        boolean isVpnRpdCapabilitySet = this.isCapabilitySupported((short)-127, (short)1, (byte)-122);
        if (!(isFsCapabilitySet || isVpnFsCapabilitySet || isRpdCapabilitySet || isVpnRpdCapabilitySet)) {
            this.log.debug("Peer do not support BGP flow spec capability", (Object)this.channel.getRemoteAddress());
            return;
        }
        if (isVpnFsCapabilitySet) {
            sAfi = -122;
        } else if (isVpnRpdCapabilitySet) {
            sAfi = -122;
        }
        attributesList.add(new Origin(0));
        if (sessionType) {
            ArrayList aspathSet;
            if (!this.bgpController.getConfig().getLargeASCapability()) {
                aspathSet = new ArrayList();
                ArrayList<Short> aspathSeq = new ArrayList<Short>();
                aspathSeq.add((short)this.bgpController.getConfig().getAsNumber());
                AsPath asPath = new AsPath(aspathSet, aspathSeq);
                attributesList.add(asPath);
            } else {
                aspathSet = new ArrayList();
                ArrayList<Integer> aspathSeq = new ArrayList<Integer>();
                aspathSeq.add(this.bgpController.getConfig().getAsNumber());
                As4Path as4Path = new As4Path(aspathSet, aspathSeq);
                attributesList.add(as4Path);
            }
            attributesList.add(new Med(0));
        } else {
            attributesList.add(new AsPath());
            attributesList.add(new Med(0));
            attributesList.add(new LocalPref(100));
        }
        attributesList.add(new BgpExtendedCommunity(flowSpec.fsActionTlv()));
        if (wideCommunity != null) {
            attributesList.add(wideCommunity);
        }
        if (operType == BgpPeer.FlowSpecOperation.ADD) {
            attributesList.add(new MpReachNlri(flowSpec, 1, sAfi));
        } else if (operType == BgpPeer.FlowSpecOperation.DELETE) {
            attributesList.add(new MpUnReachNlri(flowSpec, 1, sAfi));
        }
        BgpUpdateMsg msg = Controller.getBgpMessageFactory4().updateMessageBuilder().setBgpPathAttributes(attributesList).build();
        this.log.debug("Sending flow spec update message to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(msg));
    }

    public void updateFlowSpec(BgpPeer.FlowSpecOperation operType, BgpFlowSpecRouteKey routeKey, BgpFlowSpecNlri flowSpec, WideCommunity wideCommunity) {
        Preconditions.checkNotNull((Object)operType, (Object)"flow specification operation type cannot be null");
        Preconditions.checkNotNull((Object)routeKey, (Object)"flow specification prefix cannot be null");
        Preconditions.checkNotNull((Object)flowSpec, (Object)"flow specification details cannot be null");
        Preconditions.checkNotNull((Object)flowSpec.fsActionTlv(), (Object)"flow specification action cannot be null");
        this.sendFlowSpecUpdateMessageToPeer(operType, routeKey, flowSpec, wideCommunity);
    }

    public void buildAdjRibIn(List<BgpValueType> pathAttr) throws BgpParseException {
        ListIterator<BgpValueType> iterator = pathAttr.listIterator();
        while (iterator.hasNext()) {
            List nlri;
            BgpValueType attr = iterator.next();
            if (attr instanceof MpReachNlri) {
                nlri = ((MpReachNlri)attr).mpReachNlri();
                this.callAdd(this, nlri, pathAttr);
            }
            if (!(attr instanceof MpUnReachNlri)) continue;
            nlri = ((MpUnReachNlri)attr).mpUnReachNlri();
            this.callRemove(this, nlri);
        }
    }

    public void callAdd(BgpPeerImpl peerImpl, List<BgpLSNlri> nlri, List<BgpValueType> pathAttr) throws BgpParseException {
        ListIterator<BgpLSNlri> listIterator = nlri.listIterator();
        while (listIterator.hasNext()) {
            PathAttrNlriDetails details;
            BgpLSNlri nlriInfo = listIterator.next();
            if (nlriInfo instanceof BgpNodeLSNlriVer4) {
                details = this.setPathAttrDetails(nlriInfo, pathAttr);
                if (!((BgpNodeLSNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.add(nlriInfo, details);
                    this.bgplocalRib.add(this.sessionInfo(), nlriInfo, details);
                    continue;
                }
                this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (nlriInfo instanceof BgpLinkLsNlriVer4) {
                details = this.setPathAttrDetails(nlriInfo, pathAttr);
                if (!((BgpLinkLsNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.add(nlriInfo, details);
                    this.bgplocalRib.add(this.sessionInfo(), nlriInfo, details);
                    continue;
                }
                this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (!(nlriInfo instanceof BgpPrefixIPv4LSNlriVer4)) continue;
            details = this.setPathAttrDetails(nlriInfo, pathAttr);
            if (!((BgpPrefixIPv4LSNlriVer4)nlriInfo).isVpnPresent()) {
                this.adjRib.add(nlriInfo, details);
                this.bgplocalRib.add(this.sessionInfo(), nlriInfo, details);
                continue;
            }
            this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
            this.bgplocalRibVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
        }
    }

    public PathAttrNlriDetails setPathAttrDetails(BgpLSNlri nlriInfo, List<BgpValueType> pathAttr) throws BgpParseException {
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setProtocolID(nlriInfo.getProtocolId());
        details.setIdentifier(nlriInfo.getIdentifier());
        details.setPathAttribute(pathAttr);
        return details;
    }

    public void callRemove(BgpPeerImpl peerImpl, List<BgpLSNlri> nlri) throws BgpParseException {
        ListIterator<BgpLSNlri> listIterator = nlri.listIterator();
        while (listIterator.hasNext()) {
            BgpLSNlri nlriInfo = listIterator.next();
            if (nlriInfo instanceof BgpNodeLSNlriVer4) {
                if (!((BgpNodeLSNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.remove(nlriInfo);
                    this.bgplocalRib.delete(nlriInfo);
                    continue;
                }
                this.vpnAdjRib.removeVpn(nlriInfo, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.delete(nlriInfo, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (nlriInfo instanceof BgpLinkLsNlriVer4) {
                if (!((BgpLinkLsNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.remove(nlriInfo);
                    this.bgplocalRib.delete(nlriInfo);
                    continue;
                }
                this.vpnAdjRib.removeVpn(nlriInfo, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.delete(nlriInfo, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (!(nlriInfo instanceof BgpPrefixIPv4LSNlriVer4)) continue;
            if (!((BgpPrefixIPv4LSNlriVer4)nlriInfo).isVpnPresent()) {
                this.adjRib.remove(nlriInfo);
                this.bgplocalRib.delete(nlriInfo);
                continue;
            }
            this.vpnAdjRib.removeVpn(nlriInfo, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
            this.bgplocalRibVpn.delete(nlriInfo, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
        }
    }

    public AdjRibIn adjRib() {
        return this.adjRib;
    }

    public VpnAdjRibIn vpnAdjRib() {
        return this.vpnAdjRib;
    }

    public void updateLocalRibOnPeerDisconnect() throws BgpParseException {
        BgpLocalRibImpl localRib = (BgpLocalRibImpl)this.bgplocalRib;
        BgpLocalRibImpl localRibVpn = (BgpLocalRibImpl)this.bgplocalRibVpn;
        localRib.localRibUpdate(this.adjacencyRib());
        localRibVpn.localRibUpdate(this.vpnAdjacencyRib());
    }

    public final void disconnectPeer() {
        this.channel.close();
    }

    public final void sendMessage(BgpMessage m) {
        block2: {
            this.log.debug("Sending message to {}", (Object)this.channel.getRemoteAddress());
            try {
                this.channel.write(Collections.singletonList(m));
                this.pktStats.addOutPacket();
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final void sendMessage(List<BgpMessage> msgs) {
        block2: {
            try {
                this.channel.write(msgs);
                this.pktStats.addOutPacket(msgs.size());
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final void setConnected(boolean connected) {
        this.connected = connected;
    }

    public final void setChannel(Channel channel) {
        this.channel = channel;
        SocketAddress address = channel.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress.getAddress());
            this.channelId = ipAddress.isIp4() ? ipAddress.toString() + ':' + inetAddress.getPort() : '[' + ipAddress.toString() + "]:" + inetAddress.getPort();
        }
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public String channelId() {
        return this.channelId;
    }

    public BgpFactory factory() {
        return BgpFactories.getFactory((BgpVersion)this.sessionInfo.remoteBgpVersion());
    }

    public boolean isHandshakeComplete() {
        return this.isHandShakeComplete;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("channel", (Object)this.channelId()).add("BgpId", (Object)this.sessionInfo().remoteBgpId()).toString();
    }
}

