/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpId;
import org.onosproject.bgp.controller.BgpLinkListener;
import org.onosproject.bgp.controller.BgpLocalRib;
import org.onosproject.bgp.controller.BgpNodeListener;
import org.onosproject.bgp.controller.BgpSessionInfo;
import org.onosproject.bgp.controller.impl.AdjRibIn;
import org.onosproject.bgp.controller.impl.BgpPeerImpl;
import org.onosproject.bgp.controller.impl.BgpSelectionAlgo;
import org.onosproject.bgp.controller.impl.VpnAdjRibIn;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetailsLocalRib;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLocalRibImpl
implements BgpLocalRib {
    private static final Logger log = LoggerFactory.getLogger(BgpLocalRibImpl.class);
    private BgpController bgpController;
    private Map<BgpNodeLSIdentifier, PathAttrNlriDetailsLocalRib> nodeTree = new TreeMap<BgpNodeLSIdentifier, PathAttrNlriDetailsLocalRib>();
    private Map<BgpLinkLSIdentifier, PathAttrNlriDetailsLocalRib> linkTree = new TreeMap<BgpLinkLSIdentifier, PathAttrNlriDetailsLocalRib>();
    private Map<BgpPrefixLSIdentifier, PathAttrNlriDetailsLocalRib> prefixTree = new TreeMap<BgpPrefixLSIdentifier, PathAttrNlriDetailsLocalRib>();
    private Map<RouteDistinguisher, Map<BgpNodeLSIdentifier, PathAttrNlriDetailsLocalRib>> vpnNodeTree = new TreeMap<RouteDistinguisher, Map<BgpNodeLSIdentifier, PathAttrNlriDetailsLocalRib>>();
    private Map<RouteDistinguisher, Map<BgpLinkLSIdentifier, PathAttrNlriDetailsLocalRib>> vpnLinkTree = new TreeMap<RouteDistinguisher, Map<BgpLinkLSIdentifier, PathAttrNlriDetailsLocalRib>>();
    private Map<RouteDistinguisher, Map<BgpPrefixLSIdentifier, PathAttrNlriDetailsLocalRib>> vpnPrefixTree = new TreeMap<RouteDistinguisher, Map<BgpPrefixLSIdentifier, PathAttrNlriDetailsLocalRib>>();

    public BgpLocalRibImpl(BgpController bgpController) {
        this.bgpController = bgpController;
    }

    public Map<BgpNodeLSIdentifier, PathAttrNlriDetailsLocalRib> nodeTree() {
        return this.nodeTree;
    }

    public Map<BgpLinkLSIdentifier, PathAttrNlriDetailsLocalRib> linkTree() {
        return this.linkTree;
    }

    public Map<BgpPrefixLSIdentifier, PathAttrNlriDetailsLocalRib> prefixTree() {
        return this.prefixTree;
    }

    public Map<RouteDistinguisher, Map<BgpNodeLSIdentifier, PathAttrNlriDetailsLocalRib>> vpnNodeTree() {
        return this.vpnNodeTree;
    }

    public Map<RouteDistinguisher, Map<BgpLinkLSIdentifier, PathAttrNlriDetailsLocalRib>> vpnLinkTree() {
        return this.vpnLinkTree;
    }

    public Map<RouteDistinguisher, Map<BgpPrefixLSIdentifier, PathAttrNlriDetailsLocalRib>> vpnPrefixTree() {
        return this.vpnPrefixTree;
    }

    public void add(BgpSessionInfo sessionInfo, BgpLSNlri nlri, PathAttrNlriDetails details) throws BgpParseException {
        log.debug("Add to local RIB {}", (Object)details.toString());
        PathAttrNlriDetailsLocalRib detailsLocRib = new PathAttrNlriDetailsLocalRib(sessionInfo.remoteBgpId().ipAddress(), sessionInfo.remoteBgpIdentifier(), sessionInfo.remoteBgpASNum(), sessionInfo.isIbgpSession(), details);
        if (nlri instanceof BgpNodeLSNlriVer4) {
            BgpNodeLSIdentifier nodeLsIdentifier = ((BgpNodeLSNlriVer4)nlri).getLocalNodeDescriptors();
            if (this.nodeTree.containsKey(nodeLsIdentifier)) {
                BgpSelectionAlgo selectionAlgo = new BgpSelectionAlgo();
                int decisionResult = selectionAlgo.compare(this.nodeTree.get(nodeLsIdentifier), detailsLocRib);
                if (decisionResult <= 0) {
                    for (BgpNodeListener l : this.bgpController.listener()) {
                        l.addNode((BgpNodeLSNlriVer4)nlri, details);
                    }
                    this.nodeTree.replace(nodeLsIdentifier, detailsLocRib);
                    log.debug("Local RIB update node: {}", (Object)detailsLocRib.toString());
                }
            } else {
                this.nodeTree.put(nodeLsIdentifier, detailsLocRib);
                for (BgpNodeListener l : this.bgpController.listener()) {
                    l.addNode((BgpNodeLSNlriVer4)nlri, details);
                }
                log.debug("Local RIB ad node: {}", (Object)detailsLocRib.toString());
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            BgpLinkLSIdentifier linkLsIdentifier = ((BgpLinkLsNlriVer4)nlri).getLinkIdentifier();
            if (this.linkTree.containsKey(linkLsIdentifier)) {
                BgpSelectionAlgo selectionAlgo = new BgpSelectionAlgo();
                int decisionResult = selectionAlgo.compare(this.linkTree.get(linkLsIdentifier), detailsLocRib);
                if (decisionResult <= 0) {
                    this.linkTree.replace(linkLsIdentifier, detailsLocRib);
                    for (BgpLinkListener l : this.bgpController.linkListener()) {
                        l.addLink((BgpLinkLsNlriVer4)nlri, details);
                    }
                    log.debug("Local RIB update link: {}", (Object)detailsLocRib.toString());
                }
            } else {
                this.linkTree.put(linkLsIdentifier, detailsLocRib);
                for (BgpLinkListener l : this.bgpController.linkListener()) {
                    l.addLink((BgpLinkLsNlriVer4)nlri, details);
                }
                log.debug("Local RIB add link: {}", (Object)detailsLocRib.toString());
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4) {
            BgpPrefixLSIdentifier prefixIdentifier = ((BgpPrefixIPv4LSNlriVer4)nlri).getPrefixIdentifier();
            if (this.prefixTree.containsKey(prefixIdentifier)) {
                BgpSelectionAlgo selectionAlgo = new BgpSelectionAlgo();
                int decisionResult = selectionAlgo.compare(this.prefixTree.get(prefixIdentifier), detailsLocRib);
                if (decisionResult <= 0) {
                    this.prefixTree.replace(prefixIdentifier, detailsLocRib);
                    log.debug("Local RIB update prefix: {}", (Object)detailsLocRib.toString());
                }
            } else {
                this.prefixTree.put(prefixIdentifier, detailsLocRib);
                log.debug("Local RIB add prefix: {}", (Object)detailsLocRib.toString());
            }
        }
    }

    public void delete(BgpLSNlri nlri) throws BgpParseException {
        log.debug("Delete from local RIB.");
        this.decisionProcess(nlri);
    }

    public void decisionProcess(BgpLSNlri nlri) throws BgpParseException {
        Preconditions.checkNotNull((Object)nlri);
        if (nlri instanceof BgpNodeLSNlriVer4) {
            this.selectionProcessNode(nlri, false);
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            this.selectionProcessLink(nlri, false);
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4) {
            this.selectionProcessPrefix(nlri, false);
        }
    }

    public void decisionProcess(BgpLSNlri nlri, RouteDistinguisher routeDistinguisher) throws BgpParseException {
        Preconditions.checkNotNull((Object)nlri);
        if (nlri instanceof BgpNodeLSNlriVer4) {
            if (this.vpnNodeTree.containsKey(routeDistinguisher)) {
                this.selectionProcessNode(nlri, true);
                if (this.nodeTree.size() == 0) {
                    this.vpnNodeTree.remove(routeDistinguisher);
                }
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            if (this.vpnLinkTree.containsKey(routeDistinguisher)) {
                this.selectionProcessLink(nlri, true);
                if (this.linkTree.size() == 0) {
                    this.vpnLinkTree.remove(routeDistinguisher);
                }
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4 && this.vpnPrefixTree.containsKey(routeDistinguisher)) {
            this.selectionProcessPrefix(nlri, true);
            if (this.prefixTree.size() == 0) {
                this.vpnPrefixTree.remove(routeDistinguisher);
            }
        }
    }

    public void selectionProcessNode(BgpLSNlri nlri, boolean isVpnRib) throws BgpParseException {
        BgpNodeLSIdentifier nodeLsIdentifier = ((BgpNodeLSNlriVer4)nlri).getLocalNodeDescriptors();
        if (this.nodeTree.containsKey(nodeLsIdentifier)) {
            for (BgpNodeListener l : this.bgpController.listener()) {
                l.deleteNode((BgpNodeLSNlriVer4)nlri);
            }
            log.debug("Local RIB delete node: {}", (Object)nodeLsIdentifier.toString());
            this.nodeTree.remove(nodeLsIdentifier);
        }
        for (BgpId bgpId : this.bgpController.connectedPeers().keySet()) {
            BgpPeerImpl peer = (BgpPeerImpl)this.bgpController.getPeer(bgpId);
            if (this.nodeTree.containsKey(nodeLsIdentifier)) {
                boolean containsKey;
                boolean bl = containsKey = !isVpnRib ? peer.adjacencyRib().nodeTree().containsKey(nodeLsIdentifier) : peer.vpnAdjacencyRib().nodeTree().containsKey(nodeLsIdentifier);
                if (!containsKey) continue;
                BgpSessionInfo sessionInfo = peer.sessionInfo();
                PathAttrNlriDetailsLocalRib detailsLocRib = new PathAttrNlriDetailsLocalRib(sessionInfo.remoteBgpId().ipAddress(), sessionInfo.remoteBgpIdentifier(), sessionInfo.remoteBgpASNum(), sessionInfo.isIbgpSession(), !isVpnRib ? peer.adjacencyRib().nodeTree().get(nodeLsIdentifier) : peer.vpnAdjacencyRib().nodeTree().get(nodeLsIdentifier));
                BgpSelectionAlgo selectionAlgo = new BgpSelectionAlgo();
                int decisionResult = selectionAlgo.compare(this.nodeTree.get(nodeLsIdentifier), detailsLocRib);
                if (decisionResult >= 0) continue;
                this.nodeTree.replace(nodeLsIdentifier, detailsLocRib);
                log.debug("Local RIB node updated: {}", (Object)detailsLocRib.toString());
                continue;
            }
            if (!isVpnRib) {
                if (!peer.adjacencyRib().nodeTree().containsKey(nodeLsIdentifier)) continue;
                this.add(peer.sessionInfo(), nlri, peer.adjacencyRib().nodeTree().get(nodeLsIdentifier));
                continue;
            }
            if (!peer.vpnAdjacencyRib().nodeTree().containsKey(nodeLsIdentifier)) continue;
            this.add(peer.sessionInfo(), nlri, peer.vpnAdjacencyRib().nodeTree().get(nodeLsIdentifier));
        }
    }

    public void selectionProcessLink(BgpLSNlri nlri, boolean isVpnRib) throws BgpParseException {
        BgpLinkLSIdentifier linkLsIdentifier = ((BgpLinkLsNlriVer4)nlri).getLinkIdentifier();
        if (this.linkTree.containsKey(linkLsIdentifier)) {
            log.debug("Local RIB remove link: {}", (Object)linkLsIdentifier.toString());
            for (BgpLinkListener l : this.bgpController.linkListener()) {
                l.deleteLink((BgpLinkLsNlriVer4)nlri);
            }
            this.linkTree.remove(linkLsIdentifier);
        }
        for (BgpId bgpId : this.bgpController.connectedPeers().keySet()) {
            BgpPeerImpl peer = (BgpPeerImpl)this.bgpController.getPeer(bgpId);
            if (this.linkTree.containsKey(linkLsIdentifier)) {
                boolean containsKey;
                boolean bl = containsKey = !isVpnRib ? peer.adjacencyRib().linkTree().containsKey(linkLsIdentifier) : peer.vpnAdjacencyRib().linkTree().containsKey(linkLsIdentifier);
                if (!containsKey) continue;
                BgpSessionInfo sessionInfo = peer.sessionInfo();
                PathAttrNlriDetailsLocalRib detailsLocRib = new PathAttrNlriDetailsLocalRib(sessionInfo.remoteBgpId().ipAddress(), sessionInfo.remoteBgpIdentifier(), sessionInfo.remoteBgpASNum(), sessionInfo.isIbgpSession(), !isVpnRib ? peer.adjacencyRib().linkTree().get(linkLsIdentifier) : peer.vpnAdjacencyRib().linkTree().get(linkLsIdentifier));
                BgpSelectionAlgo selectionAlgo = new BgpSelectionAlgo();
                int decisionResult = selectionAlgo.compare(this.linkTree.get(linkLsIdentifier), detailsLocRib);
                if (decisionResult >= 0) continue;
                this.linkTree.replace(linkLsIdentifier, detailsLocRib);
                log.debug("Local RIB link updated: {}", (Object)detailsLocRib.toString());
                continue;
            }
            if (!isVpnRib) {
                if (!peer.adjacencyRib().linkTree().containsKey(linkLsIdentifier)) continue;
                this.add(peer.sessionInfo(), nlri, peer.adjacencyRib().linkTree().get(linkLsIdentifier));
                continue;
            }
            if (!peer.vpnAdjacencyRib().linkTree().containsKey(linkLsIdentifier)) continue;
            this.add(peer.sessionInfo(), nlri, peer.vpnAdjacencyRib().linkTree().get(linkLsIdentifier));
        }
    }

    public void selectionProcessPrefix(BgpLSNlri nlri, boolean isVpnRib) throws BgpParseException {
        BgpPrefixLSIdentifier prefixIdentifier = ((BgpPrefixIPv4LSNlriVer4)nlri).getPrefixIdentifier();
        if (this.prefixTree.containsKey(prefixIdentifier)) {
            log.debug("Local RIB remove prefix: {}", (Object)prefixIdentifier.toString());
            this.prefixTree.remove(prefixIdentifier);
        }
        for (BgpId bgpId : this.bgpController.connectedPeers().keySet()) {
            BgpPeerImpl peer = (BgpPeerImpl)this.bgpController.getPeer(bgpId);
            if (this.prefixTree.containsKey(prefixIdentifier)) {
                boolean containsKey;
                boolean bl = containsKey = !isVpnRib ? peer.adjacencyRib().prefixTree().containsKey(prefixIdentifier) : peer.vpnAdjacencyRib().prefixTree().containsKey(prefixIdentifier);
                if (!containsKey) continue;
                BgpSessionInfo sessionInfo = peer.sessionInfo();
                PathAttrNlriDetailsLocalRib detailsLocRib = new PathAttrNlriDetailsLocalRib(sessionInfo.remoteBgpId().ipAddress(), sessionInfo.remoteBgpIdentifier(), sessionInfo.remoteBgpASNum(), sessionInfo.isIbgpSession(), !isVpnRib ? peer.adjacencyRib().prefixTree().get(prefixIdentifier) : peer.vpnAdjacencyRib().prefixTree().get(prefixIdentifier));
                BgpSelectionAlgo selectionAlgo = new BgpSelectionAlgo();
                int decisionResult = selectionAlgo.compare(this.prefixTree.get(prefixIdentifier), detailsLocRib);
                if (decisionResult >= 0) continue;
                this.prefixTree.replace(prefixIdentifier, detailsLocRib);
                log.debug("Local RIB prefix updated: {}", (Object)detailsLocRib.toString());
                continue;
            }
            if (isVpnRib) continue;
            if (peer.adjacencyRib().prefixTree().containsKey(prefixIdentifier)) {
                this.add(peer.sessionInfo(), nlri, peer.adjacencyRib().prefixTree().get(prefixIdentifier));
                continue;
            }
            if (!peer.vpnAdjacencyRib().prefixTree().containsKey(prefixIdentifier)) continue;
            this.add(peer.sessionInfo(), nlri, peer.vpnAdjacencyRib().prefixTree().get(prefixIdentifier));
        }
    }

    public void add(BgpSessionInfo sessionInfo, BgpLSNlri nlri, PathAttrNlriDetails details, RouteDistinguisher routeDistinguisher) throws BgpParseException {
        this.add(sessionInfo, nlri, details);
        if (nlri instanceof BgpNodeLSNlriVer4) {
            if (!this.vpnNodeTree.containsKey(routeDistinguisher)) {
                this.vpnNodeTree.put(routeDistinguisher, this.nodeTree);
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            if (!this.vpnLinkTree.containsKey(routeDistinguisher)) {
                this.vpnLinkTree.put(routeDistinguisher, this.linkTree);
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4 && !this.vpnPrefixTree.containsKey(routeDistinguisher)) {
            this.vpnPrefixTree.put(routeDistinguisher, this.prefixTree);
        }
    }

    public void delete(BgpLSNlri nlri, RouteDistinguisher routeDistinguisher) throws BgpParseException {
        this.decisionProcess(nlri, routeDistinguisher);
    }

    public void localRibUpdateNode(Object o) throws BgpParseException {
        if (o instanceof AdjRibIn) {
            AdjRibIn adjRib = (AdjRibIn)o;
            log.debug("Update local RIB node.");
            Set<BgpNodeLSIdentifier> nodeKeys = adjRib.nodeTree().keySet();
            for (BgpNodeLSIdentifier key : nodeKeys) {
                PathAttrNlriDetails pathAttrNlri = adjRib.nodeTree().get(key);
                BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(pathAttrNlri.identifier(), pathAttrNlri.protocolID().getType(), key, false, null);
                this.decisionProcess((BgpLSNlri)nodeNlri);
            }
        }
        if (o instanceof VpnAdjRibIn) {
            VpnAdjRibIn vpnAdjRib = (VpnAdjRibIn)o;
            log.debug("Update local RIB VPN node.");
            Set<RouteDistinguisher> nodeKeysVpn = vpnAdjRib.vpnNodeTree().keySet();
            for (RouteDistinguisher keyVpnNode : nodeKeysVpn) {
                Map<BgpNodeLSIdentifier, PathAttrNlriDetails> node = vpnAdjRib.vpnNodeTree().get(keyVpnNode);
                Set<BgpNodeLSIdentifier> vpnNodeKeys = node.keySet();
                for (BgpNodeLSIdentifier key : vpnNodeKeys) {
                    PathAttrNlriDetails pathAttrNlri = vpnAdjRib.nodeTree().get(key);
                    BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(pathAttrNlri.identifier(), pathAttrNlri.protocolID().getType(), key, true, keyVpnNode);
                    this.decisionProcess((BgpLSNlri)nodeNlri, keyVpnNode);
                }
            }
        }
    }

    public void localRibUpdateLink(Object o) throws BgpParseException {
        if (o instanceof AdjRibIn) {
            AdjRibIn adjRib = (AdjRibIn)o;
            log.debug("Update local RIB link.");
            Set<BgpLinkLSIdentifier> linkKeys = adjRib.linkTree().keySet();
            for (BgpLinkLSIdentifier key : linkKeys) {
                PathAttrNlriDetails pathAttrNlri = adjRib.linkTree().get(key);
                BgpLinkLsNlriVer4 linkNlri = new BgpLinkLsNlriVer4(pathAttrNlri.protocolID().getType(), pathAttrNlri.identifier(), key, null, false);
                this.decisionProcess((BgpLSNlri)linkNlri);
            }
        }
        if (o instanceof VpnAdjRibIn) {
            VpnAdjRibIn vpnAdjRib = (VpnAdjRibIn)o;
            log.debug("Update local RIB VPN link");
            Set<RouteDistinguisher> linkKeysVpn = vpnAdjRib.vpnLinkTree().keySet();
            for (RouteDistinguisher keyVpnLink : linkKeysVpn) {
                Map<BgpLinkLSIdentifier, PathAttrNlriDetails> link = vpnAdjRib.vpnLinkTree().get(keyVpnLink);
                Set<BgpLinkLSIdentifier> vpnLinkKeys = link.keySet();
                for (BgpLinkLSIdentifier key : vpnLinkKeys) {
                    PathAttrNlriDetails pathAttrNlri = vpnAdjRib.linkTree().get(key);
                    BgpLinkLsNlriVer4 linkNlri = new BgpLinkLsNlriVer4(pathAttrNlri.protocolID().getType(), pathAttrNlri.identifier(), key, keyVpnLink, true);
                    this.decisionProcess((BgpLSNlri)linkNlri, keyVpnLink);
                }
            }
        }
    }

    public void localRibUpdatePrefix(Object o) throws BgpParseException {
        if (o instanceof AdjRibIn) {
            AdjRibIn adjRib = (AdjRibIn)o;
            log.debug("Update local RIB prefix.");
            Set<BgpPrefixLSIdentifier> prefixKeys = adjRib.prefixTree().keySet();
            for (BgpPrefixLSIdentifier key : prefixKeys) {
                PathAttrNlriDetails pathAttrNlri = adjRib.prefixTree().get(key);
                BgpPrefixIPv4LSNlriVer4 prefixNlri = new BgpPrefixIPv4LSNlriVer4(pathAttrNlri.identifier(), pathAttrNlri.protocolID().getType(), key, null, false);
                this.decisionProcess((BgpLSNlri)prefixNlri);
            }
        }
        if (o instanceof VpnAdjRibIn) {
            VpnAdjRibIn vpnAdjRib = (VpnAdjRibIn)o;
            log.debug("Update local RIB VPN prefix.");
            Set<RouteDistinguisher> prefixKeysVpn = vpnAdjRib.vpnPrefixTree().keySet();
            for (RouteDistinguisher keyVpnPrefix : prefixKeysVpn) {
                Map<BgpPrefixLSIdentifier, PathAttrNlriDetails> prefix = vpnAdjRib.vpnPrefixTree().get(keyVpnPrefix);
                Set<BgpPrefixLSIdentifier> vpnPrefixKeys = prefix.keySet();
                for (BgpPrefixLSIdentifier key : vpnPrefixKeys) {
                    PathAttrNlriDetails pathAttrNlri = vpnAdjRib.prefixTree().get(key);
                    BgpPrefixIPv4LSNlriVer4 prefixNlri = new BgpPrefixIPv4LSNlriVer4(pathAttrNlri.identifier(), pathAttrNlri.protocolID().getType(), key, keyVpnPrefix, true);
                    this.decisionProcess((BgpLSNlri)prefixNlri, keyVpnPrefix);
                }
            }
        }
    }

    public void localRibUpdate(AdjRibIn adjRibIn) throws BgpParseException {
        log.debug("Update local RIB.");
        this.localRibUpdateNode(adjRibIn);
        this.localRibUpdateLink(adjRibIn);
        this.localRibUpdatePrefix(adjRibIn);
    }

    public void localRibUpdate(VpnAdjRibIn vpnAdjRibIn) throws BgpParseException {
        log.debug("Update VPN local RIB.");
        this.localRibUpdateNode(vpnAdjRibIn);
        this.localRibUpdateLink(vpnAdjRibIn);
        this.localRibUpdatePrefix(vpnAdjRibIn);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("nodeTree", this.nodeTree).add("linkTree", this.linkTree).add("prefixTree", this.prefixTree).add("vpnNodeTree", this.vpnNodeTree).add("vpnLinkTree", this.vpnLinkTree).add("vpnPrefixTree", this.vpnPrefixTree).toString();
    }
}

