/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.util.Timer;
import java.util.TimerTask;
import org.onosproject.bgp.controller.impl.BgpChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpKeepAliveTimer {
    private Timer keepAliveTimer;
    private BgpChannelHandler handler;
    private static final Logger log = LoggerFactory.getLogger(BgpKeepAliveTimer.class);

    public Timer getKeepAliveTimer() {
        return this.keepAliveTimer;
    }

    public BgpKeepAliveTimer(BgpChannelHandler h, int seconds) {
        this.handler = h;
        this.keepAliveTimer = new Timer();
        this.keepAliveTimer.schedule((TimerTask)new SendKeepAlive(), 0L, (long)(seconds * 1000));
    }

    class SendKeepAlive
    extends TimerTask {
        SendKeepAlive() {
        }

        @Override
        public void run() {
            log.debug("Sending periodic KeepAlive");
            try {
                BgpKeepAliveTimer.this.handler.sendKeepAliveMessage();
                BgpKeepAliveTimer.this.handler.getBgpPacketStats().addOutPacket();
            }
            catch (Exception e) {
                log.info("Exception occured while sending keepAlive message" + e.toString());
            }
        }
    }
}

