/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpConnectPeer;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpPeerCfg;
import org.onosproject.bgp.controller.impl.BgpPipelineFactory;
import org.onosproject.bgp.controller.impl.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpConnectPeerImpl
implements BgpConnectPeer {
    private static final Logger log = LoggerFactory.getLogger(BgpConnectPeerImpl.class);
    private ScheduledExecutorService connectExecutor = null;
    private final String peerHost;
    private static final int RETRY_INTERVAL = 4;
    private final int peerPort;
    private int connectRetryCounter = 0;
    private int connectRetryTime;
    private ChannelPipelineFactory pfact;
    private ClientBootstrap peerBootstrap;
    private BgpCfg bgpconfig;

    public String getPeerHost() {
        return this.peerHost;
    }

    public static int getRetryInterval() {
        return 4;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getConnectRetryCounter() {
        return this.connectRetryCounter;
    }

    public void setConnectRetryCounter(int connectRetryCounter) {
        this.connectRetryCounter = connectRetryCounter;
    }

    public void setConnectRetryTime(int connectRetryTime) {
        this.connectRetryTime = connectRetryTime;
    }

    public BgpCfg getBgpconfig() {
        return this.bgpconfig;
    }

    public void setBgpconfig(BgpCfg bgpconfig) {
        this.bgpconfig = bgpconfig;
    }

    public BgpConnectPeerImpl(BgpController bgpController, String remoteHost, int remotePort) {
        this.bgpconfig = bgpController.getConfig();
        this.pfact = new BgpPipelineFactory(bgpController, false);
        this.peerBootstrap = Controller.peerBootstrap();
        this.peerBootstrap.setPipelineFactory(this.pfact);
        this.peerHost = remoteHost;
        this.peerPort = remotePort;
        this.connectRetryTime = 0;
    }

    public void disconnectPeer() {
        if (this.connectExecutor != null) {
            this.connectExecutor.shutdown();
            this.connectExecutor = null;
        }
    }

    public void connectPeer() {
        this.scheduleConnectionRetry(this.connectRetryTime);
    }

    private void scheduleConnectionRetry(long retryDelay) {
        if (this.connectExecutor == null) {
            this.connectExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        this.connectExecutor.schedule(new ConnectionRetry(), retryDelay, TimeUnit.MINUTES);
    }

    class ConnectionRetry
    implements Runnable {
        ConnectionRetry() {
        }

        @Override
        public void run() {
            log.debug("Connect to peer {}", (Object)BgpConnectPeerImpl.this.peerHost);
            InetSocketAddress connectToSocket = new InetSocketAddress(BgpConnectPeerImpl.this.peerHost, BgpConnectPeerImpl.this.peerPort);
            try {
                BgpConnectPeerImpl.this.bgpconfig.setPeerConnState(BgpConnectPeerImpl.this.peerHost, BgpPeerCfg.State.CONNECT);
                BgpConnectPeerImpl.this.peerBootstrap.connect((SocketAddress)connectToSocket).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            BgpConnectPeerImpl.this.bgpconfig.setPeerConnState(BgpConnectPeerImpl.this.peerHost, BgpPeerCfg.State.ACTIVE);
                            BgpConnectPeerImpl.this.connectRetryCounter++;
                            log.error("Connection failed, ConnectRetryCounter {} remote host {}", (Object)BgpConnectPeerImpl.this.connectRetryCounter, (Object)BgpConnectPeerImpl.this.peerHost);
                            if (BgpConnectPeerImpl.this.connectRetryTime < 4) {
                                BgpConnectPeerImpl.this.connectRetryTime = BgpConnectPeerImpl.this.connectRetryTime != 0 ? BgpConnectPeerImpl.this.connectRetryTime * 2 : 1;
                            }
                        } else {
                            BgpConnectPeerImpl.this.connectRetryCounter++;
                            log.debug("Connected to remote host {}, Connect Counter {}", (Object)BgpConnectPeerImpl.this.peerHost, (Object)BgpConnectPeerImpl.this.connectRetryCounter);
                            BgpConnectPeerImpl.this.disconnectPeer();
                            return;
                        }
                        BgpConnectPeerImpl.this.scheduleConnectionRetry(BgpConnectPeerImpl.this.connectRetryTime);
                    }
                });
            }
            catch (Exception e) {
                log.debug("Connect peer exception : " + e.toString());
                BgpConnectPeerImpl.this.disconnectPeer();
            }
        }
    }
}

