/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpConnectPeer;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpId;
import org.onosproject.bgp.controller.BgpPeer;
import org.onosproject.bgp.controller.BgpPeerCfg;
import org.onosproject.bgp.controller.impl.BgpConnectPeerImpl;
import org.onosproject.bgp.controller.impl.BgpControllerImpl;
import org.onosproject.bgp.controller.impl.BgpPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpConfig
implements BgpCfg {
    protected static final Logger log = LoggerFactory.getLogger(BgpConfig.class);
    private static final short DEFAULT_HOLD_TIMER = 120;
    private static final short DEFAULT_CONN_RETRY_TIME = 120;
    private static final short DEFAULT_CONN_RETRY_COUNT = 5;
    private List<BgpConnectPeerImpl> peerList = new ArrayList<BgpConnectPeerImpl>();
    private BgpCfg.State state = BgpCfg.State.INIT;
    private int localAs;
    private int maxSession;
    private boolean lsCapability;
    private short holdTime;
    private boolean largeAs = false;
    private int maxConnRetryTime;
    private int maxConnRetryCount;
    private BgpCfg.FlowSpec flowSpec = BgpCfg.FlowSpec.NONE;
    private Ip4Address routerId = null;
    private TreeMap<String, BgpPeerCfg> bgpPeerTree = new TreeMap();
    private BgpConnectPeer connectPeer;
    private BgpControllerImpl.BgpPeerManagerImpl peerManager;
    private BgpController bgpController;
    private boolean rpdCapability;

    public BgpConfig(BgpController bgpController) {
        this.bgpController = bgpController;
        this.peerManager = (BgpControllerImpl.BgpPeerManagerImpl)bgpController.peerManager();
        this.holdTime = (short)120;
        this.maxConnRetryTime = 120;
        this.maxConnRetryCount = 5;
    }

    public BgpCfg.State getState() {
        return this.state;
    }

    public void setState(BgpCfg.State state) {
        this.state = state;
    }

    public int getAsNumber() {
        return this.localAs;
    }

    public void setAsNumber(int localAs) {
        BgpCfg.State localState = this.getState();
        this.localAs = localAs;
        if (localState == BgpCfg.State.IP_CONFIGURED) {
            this.setState(BgpCfg.State.IP_AS_CONFIGURED);
        } else {
            this.setState(BgpCfg.State.AS_CONFIGURED);
        }
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(int maxSession) {
        this.maxSession = maxSession;
    }

    public boolean getLsCapability() {
        return this.lsCapability;
    }

    public void setLsCapability(boolean lsCapability) {
        this.lsCapability = lsCapability;
    }

    public BgpCfg.FlowSpec flowSpecCapability() {
        return this.flowSpec;
    }

    public void setFlowSpecCapability(BgpCfg.FlowSpec flowSpec) {
        this.flowSpec = flowSpec;
    }

    public boolean flowSpecRpdCapability() {
        return this.rpdCapability;
    }

    public void setFlowSpecRpdCapability(boolean rpdCapability) {
        this.rpdCapability = rpdCapability;
    }

    public String getRouterId() {
        if (this.routerId != null) {
            return this.routerId.toString();
        }
        return null;
    }

    public void setRouterId(String routerId) {
        BgpCfg.State localState = this.getState();
        this.routerId = Ip4Address.valueOf((String)routerId);
        if (localState == BgpCfg.State.AS_CONFIGURED) {
            this.setState(BgpCfg.State.IP_AS_CONFIGURED);
        } else {
            this.setState(BgpCfg.State.IP_CONFIGURED);
        }
    }

    public boolean addPeer(String routerid, int remoteAs) {
        return this.addPeer(routerid, remoteAs, (short)120);
    }

    public boolean addPeer(String routerid, short holdTime) {
        return this.addPeer(routerid, this.getAsNumber(), holdTime);
    }

    public boolean addPeer(String routerid, int remoteAs, short holdTime) {
        BgpPeerConfig lspeer = new BgpPeerConfig();
        if (this.bgpPeerTree.get(routerid) == null) {
            lspeer.setPeerRouterId(routerid);
            lspeer.setAsNumber(remoteAs);
            lspeer.setHoldtime(holdTime);
            lspeer.setState(BgpPeerCfg.State.IDLE);
            lspeer.setSelfInnitConnection(false);
            if (this.getAsNumber() == remoteAs) {
                lspeer.setIsIBgp(true);
            } else {
                lspeer.setIsIBgp(false);
            }
            this.bgpPeerTree.put(routerid, lspeer);
            log.debug("Added successfully");
            return true;
        }
        log.debug("Already exists");
        return false;
    }

    public boolean connectPeer(String routerid) {
        BgpPeerCfg lspeer = this.bgpPeerTree.get(routerid);
        if (lspeer != null) {
            lspeer.setSelfInnitConnection(true);
            if (lspeer.connectPeer() == null) {
                this.connectPeer = new BgpConnectPeerImpl(this.bgpController, routerid, 179);
                lspeer.setConnectPeer(this.connectPeer);
                this.connectPeer.connectPeer();
                this.peerList.add((BgpConnectPeerImpl)this.connectPeer);
            }
            return true;
        }
        return false;
    }

    public boolean removePeer(String routerid) {
        BgpPeerCfg lspeer = this.bgpPeerTree.get(routerid);
        if (lspeer != null) {
            this.disconnectPeer(routerid);
            lspeer.setSelfInnitConnection(false);
            lspeer = this.bgpPeerTree.remove(routerid);
            log.debug("Deleted : " + routerid + " successfully");
            return true;
        }
        log.debug("Did not find : " + routerid);
        return false;
    }

    public boolean disconnectPeer(String routerid) {
        BgpPeerCfg lspeer = this.bgpPeerTree.get(routerid);
        if (lspeer != null) {
            BgpPeer disconnPeer = this.peerManager.getPeer(BgpId.bgpId((IpAddress)IpAddress.valueOf((String)routerid)));
            if (disconnPeer != null) {
                disconnPeer.disconnectPeer();
            } else if (lspeer.connectPeer() != null) {
                lspeer.connectPeer().disconnectPeer();
            }
            lspeer.setState(BgpPeerCfg.State.IDLE);
            lspeer.setSelfInnitConnection(false);
            log.debug("Disconnected : " + routerid + " successfully");
            return true;
        }
        log.debug("Did not find : " + routerid);
        return false;
    }

    public void setPeerConnState(String routerid, BgpPeerCfg.State state) {
        BgpPeerCfg lspeer = this.bgpPeerTree.get(routerid);
        if (lspeer != null) {
            lspeer.setState(state);
            log.debug("Peer : " + routerid + " is not available");
            return;
        }
        log.debug("Did not find : " + routerid);
    }

    public BgpPeerCfg.State getPeerConnState(String routerid) {
        BgpPeerCfg lspeer = this.bgpPeerTree.get(routerid);
        if (lspeer != null) {
            return lspeer.getState();
        }
        return BgpPeerCfg.State.INVALID;
    }

    public boolean isPeerConnectable(String routerid) {
        BgpPeerCfg lspeer = this.bgpPeerTree.get(routerid);
        return lspeer != null && lspeer.getState().equals((Object)BgpPeerCfg.State.IDLE);
    }

    public TreeMap<String, BgpPeerCfg> getPeerTree() {
        return this.bgpPeerTree;
    }

    public TreeMap<String, BgpPeerCfg> displayPeers() {
        if (this.bgpPeerTree.isEmpty()) {
            log.debug("There are no BGP peers");
        } else {
            Set<Map.Entry<String, BgpPeerCfg>> set = this.bgpPeerTree.entrySet();
            for (Map.Entry<String, BgpPeerCfg> me : set) {
                BgpPeerCfg lspeer = me.getValue();
                log.debug("Peer neighbor IP :" + me.getKey());
                log.debug(", AS Number : " + lspeer.getAsNumber());
                log.debug(", Hold Timer : " + lspeer.getHoldtime());
                log.debug(", Is iBGP : " + lspeer.getIsIBgp());
            }
        }
        return null;
    }

    public BgpPeerCfg displayPeers(String routerid) {
        if (!this.bgpPeerTree.isEmpty()) {
            return this.bgpPeerTree.get(routerid);
        }
        log.debug("There are no Bgp peers");
        return null;
    }

    public void setHoldTime(short holdTime) {
        this.holdTime = holdTime;
    }

    public short getHoldTime() {
        return this.holdTime;
    }

    public boolean getLargeASCapability() {
        return this.largeAs;
    }

    public void setLargeASCapability(boolean largeAs) {
        this.largeAs = largeAs;
    }

    public boolean isPeerConfigured(String routerid) {
        BgpPeerCfg lspeer = this.bgpPeerTree.get(routerid);
        return lspeer != null;
    }

    public boolean isPeerConnected(String routerid) {
        return true;
    }

    public int getMaxConnRetryCount() {
        return this.maxConnRetryCount;
    }

    public void setMaxConnRetryCout(int retryCount) {
        this.maxConnRetryCount = retryCount;
    }

    public int getMaxConnRetryTime() {
        return this.maxConnRetryTime;
    }

    public void setMaxConnRetryTime(int retryTime) {
        this.maxConnRetryTime = retryTime;
    }
}

