/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpId;
import org.onosproject.bgp.controller.BgpPeer;
import org.onosproject.bgp.controller.BgpPeerCfg;
import org.onosproject.bgp.controller.impl.BgpConnectPeerImpl;
import org.onosproject.bgp.controller.impl.BgpControllerImpl;
import org.onosproject.bgp.controller.impl.BgpKeepAliveTimer;
import org.onosproject.bgp.controller.impl.BgpPacketStatsImpl;
import org.onosproject.bgp.controller.impl.BgpPeerConfig;
import org.onosproject.bgp.controller.impl.BgpPeerImpl;
import org.onosproject.bgp.controller.impl.BgpSessionInfoImpl;
import org.onosproject.bgp.controller.impl.Controller;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactory;
import org.onosproject.bgpio.protocol.BgpKeepaliveMsg;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpNotificationMsg;
import org.onosproject.bgpio.protocol.BgpOpenMsg;
import org.onosproject.bgpio.protocol.BgpType;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.FourOctetAsNumCapabilityTlv;
import org.onosproject.bgpio.types.MultiProtocolExtnCapabilityTlv;
import org.onosproject.bgpio.types.RpdCapabilityTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BgpChannelHandler
extends IdleStateAwareChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(BgpChannelHandler.class);
    static final int BGP_MIN_HOLDTIME = 3;
    static final int BGP_MAX_KEEPALIVE_INTERVAL = 3;
    private BgpPeer bgpPeer;
    private BgpId thisbgpId;
    private Channel channel;
    private BgpKeepAliveTimer keepAliveTimer = null;
    private short minHoldTime = 0;
    private short peerHoldTime = 0;
    private long peerAsNum;
    private int peerIdentifier;
    private BgpPacketStatsImpl bgpPacketStats;
    static final int MAX_WRONG_COUNT_PACKET = 5;
    static final byte MULTI_PROTOCOL_EXTN_CAPA_TYPE = 1;
    static final byte FOUR_OCTET_AS_NUM_CAPA_TYPE = 65;
    static final int AS_TRANS = 23456;
    static final int MAX_AS2_NUM = 65535;
    static final short AFI = 16388;
    static final byte RES = 0;
    static final byte SAFI = 71;
    static final byte MAX_UNSUPPORTED_CAPABILITY = 5;
    private volatile ChannelState state;
    private volatile Boolean duplicateBgpIdFound;
    protected BgpVersion bgpVersion;
    private BgpController bgpController;
    protected BgpFactory factory4;
    private boolean isIbgpSession;
    private BgpSessionInfoImpl sessionInfo;
    private BgpControllerImpl.BgpPeerManagerImpl peerManager;
    private InetSocketAddress inetAddress;
    private IpAddress ipAddress;
    private SocketAddress address;
    private String peerAddr;
    private BgpCfg bgpconfig;
    List<BgpValueType> remoteBgpCapability;
    private Timer timer = new HashedWheelTimer(Tools.groupedThreads((String)"BgpChannel", (String)"timer-%d", (Logger)log));
    private volatile Timeout holdTimerTimeout;

    BgpChannelHandler(BgpController bgpController) {
        this.bgpController = bgpController;
        this.peerManager = (BgpControllerImpl.BgpPeerManagerImpl)bgpController.peerManager();
        this.state = ChannelState.IDLE;
        this.factory4 = Controller.getBgpMessageFactory4();
        this.duplicateBgpIdFound = Boolean.FALSE;
        this.bgpPacketStats = new BgpPacketStatsImpl();
        this.bgpconfig = bgpController.getConfig();
    }

    public void disconnectPeer() {
        this.bgpPeer.disconnectPeer();
    }

    private void stopKeepAliveTimer() {
        if (this.keepAliveTimer != null && this.keepAliveTimer.getKeepAliveTimer() != null) {
            this.keepAliveTimer.getKeepAliveTimer().cancel();
        }
    }

    private void stopSessionTimers() {
        if (this.keepAliveTimer != null && this.keepAliveTimer.getKeepAliveTimer() != null) {
            this.keepAliveTimer.getKeepAliveTimer().cancel();
        }
        if (this.holdTimerTimeout != null) {
            this.holdTimerTimeout.cancel();
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = e.getChannel();
        log.info("BGP connected from {}", (Object)this.channel.getRemoteAddress());
        this.address = this.channel.getRemoteAddress();
        if (!(this.address instanceof InetSocketAddress)) {
            throw new IOException("Invalid peer connection.");
        }
        if (this.bgpconfig.getState() != BgpCfg.State.IP_AS_CONFIGURED) {
            this.sendNotification((byte)6, (byte)5, null);
            this.channel.close();
            log.info("BGP local AS and router ID not configured");
            return;
        }
        this.inetAddress = (InetSocketAddress)this.address;
        this.peerAddr = IpAddress.valueOf((InetAddress)this.inetAddress.getAddress()).toString();
        if (!this.bgpconfig.isPeerConfigured(this.peerAddr)) {
            log.debug("Peer is not configured {}", (Object)this.peerAddr);
            this.sendNotification((byte)6, (byte)5, null);
            this.channel.close();
            return;
        }
        if (this.peerManager.isPeerConnected(BgpId.bgpId((IpAddress)IpAddress.valueOf((String)this.peerAddr)))) {
            log.debug("Duplicate connection received, peer {}", (Object)this.peerAddr);
            this.channel.close();
            return;
        }
        if (null != this.channel.getPipeline().get("PassiveHandler")) {
            log.info("BGP handle connection request from peer");
            this.setState(ChannelState.OPENWAIT);
        } else if (null != this.channel.getPipeline().get("ActiveHandler")) {
            log.info("BGP handle connection response from peer");
            this.sendHandshakeOpenMessage();
            this.bgpPacketStats.addOutPacket();
            this.setState(ChannelState.OPENSENT);
            this.bgpconfig.setPeerConnState(this.peerAddr, BgpPeerCfg.State.OPENSENT);
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = e.getChannel();
        log.info("BGP disconnected callback for bgp:{}. Cleaning up ...", (Object)this.getPeerInfoString());
        this.address = this.channel.getRemoteAddress();
        if (!(this.address instanceof InetSocketAddress)) {
            throw new IOException("Invalid peer connection.");
        }
        this.inetAddress = (InetSocketAddress)this.address;
        this.peerAddr = IpAddress.valueOf((InetAddress)this.inetAddress.getAddress()).toString();
        if (this.thisbgpId != null) {
            if (!this.duplicateBgpIdFound.booleanValue()) {
                log.debug("{}:removal called", (Object)this.getPeerInfoString());
                if (this.bgpPeer != null) {
                    BgpPeerImpl peer = (BgpPeerImpl)this.bgpPeer;
                    this.peerManager.removeConnectedPeer(this.thisbgpId);
                    peer.updateLocalRibOnPeerDisconnect();
                }
                if (this.channel != null && null != this.channel.getPipeline().get("ActiveHandler")) {
                    BgpPeerCfg.State peerCfgState = this.bgpconfig.getPeerConnState(this.peerAddr);
                    if (!peerCfgState.equals((Object)BgpPeerCfg.State.IDLE)) {
                        log.debug("Connection reset by peer, retry, STATE:{}", (Object)peerCfgState);
                        BgpPeerConfig peerConfig = (BgpPeerConfig)this.bgpconfig.displayPeers(this.peerAddr);
                        this.bgpconfig.setPeerConnState(this.peerAddr, BgpPeerCfg.State.IDLE);
                        BgpConnectPeerImpl connectPeer = new BgpConnectPeerImpl(this.bgpController, this.peerAddr, Controller.getBgpPortNum());
                        peerConfig.setConnectPeer(connectPeer);
                    }
                } else {
                    this.bgpconfig.setPeerConnState(this.peerAddr, BgpPeerCfg.State.IDLE);
                }
            } else {
                log.debug("{}:duplicate found", (Object)this.getPeerInfoString());
                this.duplicateBgpIdFound = Boolean.FALSE;
            }
            this.stopSessionTimers();
        } else {
            this.bgpconfig.setPeerConnState(this.peerAddr, BgpPeerCfg.State.IDLE);
            log.warn("No bgp ip in channelHandler registered for disconnected peer {}", (Object)this.getPeerInfoString());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.error("[exceptionCaught]: " + e.toString());
        if (e.getCause() instanceof ClosedChannelException) {
            this.bgpController.activeSessionExceptionAdd(this.peerAddr, e.getCause().toString());
            log.debug("Channel for bgp {} already closed", (Object)this.getPeerInfoString());
        } else if (e.getCause() instanceof IOException) {
            log.error("Disconnecting peer {} due to IO Error: {}", (Object)this.getPeerInfoString(), (Object)e.getCause().getMessage());
            this.bgpController.closedSessionExceptionAdd(this.peerAddr, e.getCause().toString());
            if (log.isDebugEnabled()) {
                log.debug("StackTrace for previous Exception: ", e.getCause());
            }
            this.stopSessionTimers();
            ctx.getChannel().close();
        } else if (e.getCause() instanceof BgpParseException) {
            byte[] data = new byte[]{};
            BgpParseException errMsg = (BgpParseException)e.getCause();
            byte errorCode = errMsg.getErrorCode();
            byte errorSubCode = errMsg.getErrorSubCode();
            this.bgpController.activeSessionExceptionAdd(this.peerAddr, e.getCause().toString());
            ChannelBuffer tempCb = errMsg.getData();
            if (tempCb != null) {
                int dataLength = tempCb.readableBytes();
                data = new byte[dataLength];
                tempCb.readBytes(data, 0, dataLength);
            }
            this.sendNotification(errorCode, errorSubCode, data);
        } else if (e.getCause() instanceof RejectedExecutionException) {
            log.warn("Could not process message: queue full");
            this.bgpController.activeSessionExceptionAdd(this.peerAddr, e.getCause().toString());
        } else {
            this.stopSessionTimers();
            log.error("Error while processing message from peer " + this.getPeerInfoString() + "state " + (Object)((Object)this.state));
            this.bgpController.closedSessionExceptionAdd(this.peerAddr, e.getCause().toString());
            ctx.getChannel().close();
        }
    }

    public String toString() {
        return this.getPeerInfoString();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof List) {
            List msglist = (List)e.getMessage();
            for (BgpMessage pm : msglist) {
                this.state.processBgpMessage(this, pm);
            }
        } else {
            this.state.processBgpMessage(this, (BgpMessage)e.getMessage());
        }
    }

    public boolean connectionCollisionDetection(BgpPeerCfg.State state, int peerIdentifier, String peerAddr) throws IOException, BgpParseException {
        BgpPeerCfg.State currentState = this.bgpconfig.getPeerConnState(peerAddr);
        if (currentState.equals((Object)state) && Ip4Address.valueOf((String)this.bgpconfig.getRouterId()).compareTo((IpAddress)Ip4Address.valueOf((int)peerIdentifier)) > 0) {
            this.sendNotification((byte)6, (byte)7, null);
            log.debug("Connection collision detected, local id: {},  peer id: {}, peer state:{}, in state:{}", new Object[]{Ip4Address.valueOf((String)this.bgpconfig.getRouterId()), Ip4Address.valueOf((int)peerIdentifier), currentState, state});
            return true;
        }
        return false;
    }

    public void setHandshakeComplete(boolean handshakeComplete) {
        this.state.setHandshakeComplete(handshakeComplete);
    }

    public boolean isHandshakeComplete() {
        return this.state.isHandshakeComplete();
    }

    private void dispatchMessage(BgpMessage m) throws BgpParseException {
        this.bgpPacketStats.addInPacket();
        this.bgpController.processBgpPacket(this.thisbgpId, m);
    }

    private String getPeerInfoString() {
        if (this.bgpPeer != null) {
            return this.bgpPeer.toString();
        }
        String channelString = this.channel == null || this.channel.getRemoteAddress() == null ? "?" : this.channel.getRemoteAddress().toString();
        String bgpIpString = "?";
        return String.format("[%s BGP-IP[%s]]", channelString, bgpIpString);
    }

    private void setState(ChannelState state) {
        this.state = state;
    }

    public BgpPacketStatsImpl getBgpPacketStats() {
        return this.bgpPacketStats;
    }

    private void sendHandshakeOpenMessage() throws IOException, BgpParseException {
        BgpCfg.FlowSpec flowSpec = this.bgpconfig.flowSpecCapability();
        boolean flowSpecStatus = false;
        boolean vpnFlowSpecStatus = false;
        int bgpId = Ip4Address.valueOf((String)this.bgpconfig.getRouterId()).toInt();
        if (flowSpec == BgpCfg.FlowSpec.IPV4) {
            flowSpecStatus = true;
        } else if (flowSpec == BgpCfg.FlowSpec.VPNV4) {
            vpnFlowSpecStatus = true;
        } else if (flowSpec == BgpCfg.FlowSpec.IPV4_VPNV4) {
            flowSpecStatus = true;
            vpnFlowSpecStatus = true;
        }
        BgpOpenMsg msg = this.factory4.openMessageBuilder().setAsNumber((short)this.bgpconfig.getAsNumber()).setHoldTime(this.bgpconfig.getHoldTime()).setBgpId(bgpId).setLsCapabilityTlv(this.bgpconfig.getLsCapability()).setLargeAsCapabilityTlv(this.bgpconfig.getLargeASCapability()).setFlowSpecCapabilityTlv(flowSpecStatus).setVpnFlowSpecCapabilityTlv(vpnFlowSpecStatus).setFlowSpecRpdCapabilityTlv(this.bgpconfig.flowSpecRpdCapability()).build();
        log.debug("Sending open message to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(msg));
    }

    private void sendNotification(byte errorCode, byte errorSubCode, byte[] data) throws IOException, BgpParseException {
        BgpNotificationMsg msg = this.factory4.notificationMessageBuilder().setErrorCode(errorCode).setErrorSubCode(errorSubCode).setData(data).build();
        log.debug("Sending notification message to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(msg));
    }

    synchronized void sendKeepAliveMessage() throws IOException, BgpParseException {
        BgpKeepaliveMsg msg = this.factory4.keepaliveMessageBuilder().build();
        log.debug("Sending keepalive message to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(msg));
    }

    public void processUnknownMsg(byte errorCode, byte errorSubCode, byte data) throws BgpParseException, IOException {
        log.debug("Unknown message received");
        byte[] byteArray = new byte[]{data};
        this.sendNotification(errorCode, errorSubCode, byteArray);
        this.channel.close();
    }

    public boolean openMsgValidation(BgpChannelHandler h, BgpOpenMsg openMsg) throws BgpParseException {
        boolean result = this.bgpIdValidation(openMsg);
        if (!result) {
            throw new BgpParseException(2, 3, null);
        }
        result = this.asNumberValidation(h, openMsg);
        if (!result) {
            throw new BgpParseException(2, 2, null);
        }
        if (openMsg.getHoldTime() != 0 && openMsg.getHoldTime() < 3) {
            throw new BgpParseException(2, 5, null);
        }
        result = this.capabilityValidation(h, openMsg);
        return result;
    }

    private boolean capabilityValidation(BgpChannelHandler h, BgpOpenMsg openmsg) throws BgpParseException {
        MultiProtocolExtnCapabilityTlv tempTlv;
        log.debug("capability validation");
        boolean isFourOctetCapabilityExits = false;
        boolean isRpdCapabilityExits = false;
        int capAsNum = 0;
        int sendReceive = 0;
        LinkedList capabilityTlv = openmsg.getCapabilityTlv();
        ListIterator listIterator = capabilityTlv.listIterator();
        CopyOnWriteArrayList<MultiProtocolExtnCapabilityTlv> unSupportedCapabilityTlv = new CopyOnWriteArrayList<MultiProtocolExtnCapabilityTlv>();
        ListIterator unSupportedCaplistIterator = unSupportedCapabilityTlv.listIterator();
        boolean isLargeAsCapabilityCfg = h.bgpconfig.getLargeASCapability();
        boolean isFlowSpecRpdCapabilityCfg = h.bgpconfig.flowSpecRpdCapability();
        boolean isLsCapabilityCfg = h.bgpconfig.getLsCapability();
        boolean isFlowSpecIpv4CapabilityCfg = false;
        boolean isFlowSpecVpnv4CapabilityCfg = false;
        boolean isMultiProtocolLsCapability = false;
        boolean isMultiProtocolFlowSpecCapability = false;
        boolean isMultiProtocolVpnFlowSpecCapability = false;
        BgpCfg.FlowSpec flowSpec = h.bgpconfig.flowSpecCapability();
        if (flowSpec == BgpCfg.FlowSpec.IPV4) {
            isFlowSpecIpv4CapabilityCfg = true;
        } else if (flowSpec == BgpCfg.FlowSpec.VPNV4) {
            isFlowSpecVpnv4CapabilityCfg = true;
        } else if (flowSpec == BgpCfg.FlowSpec.IPV4_VPNV4) {
            isFlowSpecIpv4CapabilityCfg = true;
            isFlowSpecVpnv4CapabilityCfg = true;
        }
        while (listIterator.hasNext()) {
            BgpValueType tlv = (BgpValueType)listIterator.next();
            if (tlv.getType() == 1) {
                MultiProtocolExtnCapabilityTlv tempCapability = (MultiProtocolExtnCapabilityTlv)tlv;
                if (-123 == tempCapability.getSafi()) {
                    isMultiProtocolFlowSpecCapability = true;
                }
                if (-122 == tempCapability.getSafi()) {
                    isMultiProtocolVpnFlowSpecCapability = true;
                }
                if (71 == tempCapability.getSafi()) {
                    isMultiProtocolLsCapability = true;
                }
            }
            if (tlv.getType() == 65) {
                isFourOctetCapabilityExits = true;
                capAsNum = ((FourOctetAsNumCapabilityTlv)tlv).getInt();
            }
            if (tlv.getType() != -127) continue;
            isRpdCapabilityExits = true;
            sendReceive = ((RpdCapabilityTlv)tlv).sendReceive();
        }
        if (isFourOctetCapabilityExits && (capAsNum > 65535 ? openmsg.getAsNumber() != 23456L : (long)capAsNum != openmsg.getAsNumber())) {
            throw new BgpParseException(2, 2, null);
        }
        if (isRpdCapabilityExits && sendReceive > 2) {
            throw new BgpParseException(2, 7, null);
        }
        if (isLsCapabilityCfg && !isMultiProtocolLsCapability) {
            tempTlv = new MultiProtocolExtnCapabilityTlv(16388, 0, 71);
            unSupportedCapabilityTlv.add(tempTlv);
        }
        if (isFlowSpecIpv4CapabilityCfg && !isMultiProtocolFlowSpecCapability) {
            tempTlv = new MultiProtocolExtnCapabilityTlv(1, 0, -123);
            unSupportedCapabilityTlv.add(tempTlv);
        }
        if (isFlowSpecVpnv4CapabilityCfg && !isMultiProtocolVpnFlowSpecCapability) {
            tempTlv = new MultiProtocolExtnCapabilityTlv(1, 0, -122);
            unSupportedCapabilityTlv.add(tempTlv);
        }
        if (isLargeAsCapabilityCfg && !isFourOctetCapabilityExits) {
            tempTlv = new FourOctetAsNumCapabilityTlv(h.bgpconfig.getAsNumber());
            unSupportedCapabilityTlv.add(tempTlv);
        }
        if (isFlowSpecRpdCapabilityCfg && !isRpdCapabilityExits) {
            tempTlv = new RpdCapabilityTlv(1);
            unSupportedCapabilityTlv.add(tempTlv);
        }
        if (unSupportedCapabilityTlv.size() == 5) {
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
            while (unSupportedCaplistIterator.hasNext()) {
                BgpValueType tlv = (BgpValueType)unSupportedCaplistIterator.next();
                tlv.write(buffer);
            }
            throw new BgpParseException(2, 7, buffer);
        }
        return true;
    }

    private boolean asNumberValidation(BgpChannelHandler h, BgpOpenMsg openMsg) {
        log.debug("AS number validation");
        int capAsNum = 0;
        boolean isFourOctetCapabilityExits = false;
        BgpPeerCfg peerCfg = h.bgpconfig.displayPeers(this.peerAddr);
        LinkedList capabilityTlv = openMsg.getCapabilityTlv();
        ListIterator listIterator = capabilityTlv.listIterator();
        while (listIterator.hasNext()) {
            BgpValueType tlv = (BgpValueType)listIterator.next();
            if (tlv.getType() != 65) continue;
            isFourOctetCapabilityExits = true;
            capAsNum = ((FourOctetAsNumCapabilityTlv)tlv).getInt();
        }
        if (peerCfg.getAsNumber() > 65535) {
            if (openMsg.getAsNumber() != 23456L) {
                return false;
            }
            if (!isFourOctetCapabilityExits) {
                return false;
            }
            if (peerCfg.getAsNumber() != capAsNum) {
                return false;
            }
            this.isIbgpSession = peerCfg.getIsIBgp();
            if (this.isIbgpSession && h.bgpconfig.getAsNumber() != capAsNum) {
                return false;
            }
        } else {
            if (openMsg.getAsNumber() != (long)peerCfg.getAsNumber()) {
                return false;
            }
            if (isFourOctetCapabilityExits && capAsNum != peerCfg.getAsNumber()) {
                return false;
            }
            this.isIbgpSession = peerCfg.getIsIBgp();
            if (this.isIbgpSession && openMsg.getAsNumber() != (long)h.bgpconfig.getAsNumber()) {
                return false;
            }
        }
        return true;
    }

    private boolean bgpIdValidation(BgpOpenMsg openMsg) {
        String openMsgBgpId = Ip4Address.valueOf((int)openMsg.getBgpId()).toString();
        try {
            InetAddress ipAddress = InetAddress.getByName(openMsgBgpId);
            if (ipAddress.isMulticastAddress()) {
                return false;
            }
        }
        catch (UnknownHostException e) {
            log.debug("InetAddress convertion failed");
        }
        return true;
    }

    void restartHoldTimeoutTimer() {
        if (this.peerHoldTime == 0) {
            return;
        }
        if (this.holdTimerTimeout != null) {
            this.holdTimerTimeout.cancel();
        }
        this.holdTimerTimeout = this.timer.newTimeout((TimerTask)new HoldTimerTimeout(), (long)this.minHoldTime, TimeUnit.SECONDS);
    }

    private final class HoldTimerTimeout
    implements TimerTask {
        private HoldTimerTimeout() {
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (!BgpChannelHandler.this.channel.isOpen()) {
                return;
            }
            log.debug("BGP hold timer expired: peer {}", (Object)BgpChannelHandler.this.channel.getRemoteAddress());
            BgpChannelHandler.this.sendNotification((byte)4, (byte)0, null);
            BgpChannelHandler.this.bgpController.closedSessionExceptionAdd(BgpChannelHandler.this.peerAddr, "BGP hold timer expired");
            BgpChannelHandler.this.stopSessionTimers();
            BgpChannelHandler.this.state = ChannelState.IDLE;
            BgpChannelHandler.this.channel.close();
        }
    }

    static enum ChannelState {
        IDLE(false){}
        ,
        OPENSENT(false){

            @Override
            void processBgpMessage(BgpChannelHandler h, BgpMessage m) throws IOException, BgpParseException {
                log.debug("message received in OPENSENT state");
                if (m.getType() != BgpType.OPEN) {
                    h.processUnknownMsg((byte)5, (byte)1, m.getType().getType());
                    log.debug("Message is not OPEN message");
                } else {
                    log.debug("Sending keep alive message in OPENSENT state");
                    h.bgpPacketStats.addInPacket();
                    BgpOpenMsg pOpenmsg = (BgpOpenMsg)m;
                    h.peerIdentifier = pOpenmsg.getBgpId();
                    if (h.openMsgValidation(h, pOpenmsg)) {
                        if (h.connectionCollisionDetection(BgpPeerCfg.State.OPENCONFIRM, h.peerIdentifier, h.peerAddr)) {
                            h.channel.close();
                            return;
                        }
                        log.debug("Sending handshake OPEN message");
                        h.remoteBgpCapability = pOpenmsg.getCapabilityTlv();
                        h.peerHoldTime = pOpenmsg.getHoldTime();
                        h.minHoldTime = (short)Math.min(h.bgpconfig.getHoldTime(), pOpenmsg.getHoldTime());
                        h.restartHoldTimeoutTimer();
                        log.info("Hold Time : " + h.minHoldTime);
                        h.peerAsNum = pOpenmsg.getAsNumber();
                    }
                    h.sendKeepAliveMessage();
                    h.bgpPacketStats.addOutPacket();
                    h.setState(2.OPENCONFIRM);
                    h.bgpconfig.setPeerConnState(h.peerAddr, BgpPeerCfg.State.OPENCONFIRM);
                }
            }
        }
        ,
        OPENWAIT(false){

            @Override
            void processBgpMessage(BgpChannelHandler h, BgpMessage m) throws IOException, BgpParseException {
                log.debug("Message received in OPEN WAIT State");
                if (m.getType() != BgpType.OPEN) {
                    h.processUnknownMsg((byte)5, (byte)0, m.getType().getType());
                    log.debug("Message is not OPEN message");
                } else {
                    h.bgpPacketStats.addInPacket();
                    BgpOpenMsg pOpenmsg = (BgpOpenMsg)m;
                    h.peerIdentifier = pOpenmsg.getBgpId();
                    if (h.openMsgValidation(h, pOpenmsg)) {
                        if (h.connectionCollisionDetection(BgpPeerCfg.State.OPENSENT, h.peerIdentifier, h.peerAddr)) {
                            h.channel.close();
                            return;
                        }
                        log.debug("Sending handshake OPEN message");
                        h.remoteBgpCapability = pOpenmsg.getCapabilityTlv();
                        h.peerHoldTime = pOpenmsg.getHoldTime();
                        h.minHoldTime = (short)Math.min(h.bgpconfig.getHoldTime(), pOpenmsg.getHoldTime());
                        h.restartHoldTimeoutTimer();
                        log.debug("Hold Time : " + h.minHoldTime);
                        h.peerAsNum = pOpenmsg.getAsNumber();
                        h.sendHandshakeOpenMessage();
                        h.bgpPacketStats.addOutPacket();
                        h.setState(3.OPENCONFIRM);
                        h.bgpconfig.setPeerConnState(h.peerAddr, BgpPeerCfg.State.OPENCONFIRM);
                    }
                }
            }
        }
        ,
        OPENCONFIRM(false){

            @Override
            void processBgpMessage(BgpChannelHandler h, BgpMessage m) throws IOException, BgpParseException {
                log.debug("Message received in OPENCONFIRM state");
                if (m.getType() != BgpType.KEEP_ALIVE) {
                    h.processUnknownMsg((byte)5, (byte)2, m.getType().getType());
                    log.debug("Message is not KEEPALIVE message");
                } else {
                    h.bgpPacketStats.addInPacket();
                    log.debug("Sending keep alive message in OPENCONFIRM state");
                    InetSocketAddress inetAddress = (InetSocketAddress)h.address;
                    h.thisbgpId = BgpId.bgpId((IpAddress)IpAddress.valueOf((InetAddress)inetAddress.getAddress()));
                    h.sessionInfo = new BgpSessionInfoImpl(h.thisbgpId, h.bgpVersion, h.peerAsNum, h.peerHoldTime, h.peerIdentifier, h.minHoldTime, h.isIbgpSession, h.remoteBgpCapability);
                    h.bgpPeer = h.peerManager.getBgpPeerInstance(h.bgpController, h.sessionInfo, h.bgpPacketStats);
                    h.bgpPeer.setConnected(true);
                    h.bgpPeer.setChannel(h.channel);
                    if (h.minHoldTime != 0) {
                        h.keepAliveTimer = new BgpKeepAliveTimer(h, h.minHoldTime / 3);
                    } else {
                        h.sendKeepAliveMessage();
                    }
                    h.bgpPacketStats.addOutPacket();
                    h.setHandshakeComplete(true);
                    h.restartHoldTimeoutTimer();
                    if (!h.peerManager.addConnectedPeer(h.thisbgpId, h.bgpPeer)) {
                        this.disconnectDuplicate(h);
                    } else {
                        h.setState(4.ESTABLISHED);
                        h.bgpconfig.setPeerConnState(h.peerAddr, BgpPeerCfg.State.ESTABLISHED);
                    }
                }
            }
        }
        ,
        ESTABLISHED(true){

            @Override
            void processBgpMessage(BgpChannelHandler h, BgpMessage m) throws IOException, BgpParseException {
                log.debug("Message received in established state " + m.getType());
                h.restartHoldTimeoutTimer();
                h.dispatchMessage(m);
            }
        };

        private boolean handshakeComplete;

        private ChannelState(boolean handshakeComplete) {
            this.handshakeComplete = handshakeComplete;
        }

        public boolean isHandshakeComplete() {
            return this.handshakeComplete;
        }

        protected void disconnectDuplicate(BgpChannelHandler h) {
            log.error("Duplicated BGP IP or incompleted cleanup - disconnecting channel {}", (Object)h.getPeerInfoString());
            h.duplicateBgpIdFound = Boolean.TRUE;
            h.channel.disconnect();
        }

        public void setHandshakeComplete(boolean handshakeComplete) {
            this.handshakeComplete = handshakeComplete;
        }

        void processBgpMessage(BgpChannelHandler bgpChannelHandler, BgpMessage pm) throws IOException, BgpParseException {
            log.debug("BGP message stub");
        }
    }
}

