/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.TreeMap;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;

public class AdjRibIn {
    private Map<BgpNodeLSIdentifier, PathAttrNlriDetails> nodeTree = new TreeMap<BgpNodeLSIdentifier, PathAttrNlriDetails>();
    private Map<BgpLinkLSIdentifier, PathAttrNlriDetails> linkTree = new TreeMap<BgpLinkLSIdentifier, PathAttrNlriDetails>();
    private Map<BgpPrefixLSIdentifier, PathAttrNlriDetails> prefixTree = new TreeMap<BgpPrefixLSIdentifier, PathAttrNlriDetails>();

    public Map<BgpNodeLSIdentifier, PathAttrNlriDetails> nodeTree() {
        return this.nodeTree;
    }

    public Map<BgpLinkLSIdentifier, PathAttrNlriDetails> linkTree() {
        return this.linkTree;
    }

    public Map<BgpPrefixLSIdentifier, PathAttrNlriDetails> prefixTree() {
        return this.prefixTree;
    }

    public void add(BgpLSNlri nlri, PathAttrNlriDetails details) {
        if (nlri instanceof BgpNodeLSNlriVer4) {
            BgpNodeLSIdentifier nodeLSIdentifier = ((BgpNodeLSNlriVer4)nlri).getLocalNodeDescriptors();
            if (this.nodeTree.containsKey(nodeLSIdentifier)) {
                this.nodeTree.replace(nodeLSIdentifier, details);
            } else {
                this.nodeTree.put(nodeLSIdentifier, details);
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            BgpLinkLSIdentifier linkLSIdentifier = ((BgpLinkLsNlriVer4)nlri).getLinkIdentifier();
            if (this.linkTree.containsKey(linkLSIdentifier)) {
                this.linkTree.replace(linkLSIdentifier, details);
            } else {
                this.linkTree.put(linkLSIdentifier, details);
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4) {
            BgpPrefixLSIdentifier prefixIdentifier = ((BgpPrefixIPv4LSNlriVer4)nlri).getPrefixIdentifier();
            if (this.prefixTree.containsKey(prefixIdentifier)) {
                this.prefixTree.replace(prefixIdentifier, details);
            } else {
                this.prefixTree.put(prefixIdentifier, details);
            }
        }
    }

    public void remove(BgpLSNlri nlri) {
        BgpPrefixLSIdentifier prefixIdentifier;
        if (nlri instanceof BgpNodeLSNlriVer4) {
            BgpNodeLSIdentifier nodeLSIdentifier = ((BgpNodeLSNlriVer4)nlri).getLocalNodeDescriptors();
            if (this.nodeTree.containsKey(nodeLSIdentifier)) {
                this.nodeTree.remove(nodeLSIdentifier);
            }
        } else if (nlri instanceof BgpLinkLsNlriVer4) {
            BgpLinkLSIdentifier linkLSIdentifier = ((BgpLinkLsNlriVer4)nlri).getLinkIdentifier();
            if (this.linkTree.containsKey(linkLSIdentifier)) {
                this.linkTree.remove(linkLSIdentifier);
            }
        } else if (nlri instanceof BgpPrefixIPv4LSNlriVer4 && this.prefixTree.containsKey(prefixIdentifier = ((BgpPrefixIPv4LSNlriVer4)nlri).getPrefixIdentifier())) {
            this.prefixTree.remove(prefixIdentifier);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("nodeTree", this.nodeTree).add("linkTree", this.linkTree).add("prefixTree", this.prefixTree).toString();
    }
}

