/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pceweb;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.Ip4Address;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.onosproject.ui.UiTopoOverlay;
import org.onosproject.ui.topo.ButtonId;
import org.onosproject.ui.topo.PropertyPanel;
import org.onosproject.ui.topo.TopoConstants;

public class PceWebTopovOverlay
extends UiTopoOverlay {
    private static final String OVERLAY_ID = "PCE-web-overlay";
    private static final String MY_TITLE = "Device details";
    public static final String AS_NUMBER = "asNumber";
    public static final String LSR_ID = "lsrId";
    public static final String ABR_BIT = "abrBit";
    public static final String ASBR_BIT = "externalBit";
    public static final String TE_METRIC = "teCost";
    public static final String ABR = "ABR";
    public static final String ASBR = "ASBR";
    public static final String ABR_ASBR = "ABR/ASBR";
    public static final String INNER = "Inner";
    public static final long IDENTIFIER_SET = 0x100000000L;
    public static final long SET = 0xFFFFFFFFL;

    public PceWebTopovOverlay() {
        super(OVERLAY_ID);
    }

    public void deactivate() {
        super.deactivate();
        this.log.debug("Deactivated");
    }

    public void modifyDeviceDetails(PropertyPanel pp, DeviceId deviceId) {
        pp.title(MY_TITLE);
        DeviceService deviceService = (DeviceService)AbstractShellCommand.get(DeviceService.class);
        pp.removeAllProps();
        pp.removeButtons(new ButtonId[]{TopoConstants.CoreButtons.SHOW_PORT_VIEW}).removeButtons(new ButtonId[]{TopoConstants.CoreButtons.SHOW_GROUP_VIEW}).removeButtons(new ButtonId[]{TopoConstants.CoreButtons.SHOW_METER_VIEW});
        if (deviceService != null) {
            Device device = deviceService.getDevice(deviceId);
            Annotations annots = device.annotations();
            String type = annots.value("type");
            String asNumber = annots.value(AS_NUMBER);
            String lsrId = annots.value(LSR_ID);
            String abrStatus = annots.value(ABR_BIT);
            String asbrStatus = annots.value(ASBR_BIT);
            if (type != null) {
                pp.addProp("Type", type);
            }
            if (asNumber != null) {
                pp.addProp("AS Number", asNumber);
            }
            if (lsrId != null) {
                pp.addProp("LSR ID", lsrId);
            }
            if (Boolean.valueOf(abrStatus).equals(true) && Boolean.valueOf(asbrStatus).equals(true)) {
                pp.addProp("Position", ABR_ASBR);
            } else if (Boolean.valueOf(abrStatus).equals(true)) {
                pp.addProp("Position", ABR);
            } else if (Boolean.valueOf(asbrStatus).equals(true)) {
                pp.addProp("Position", ASBR);
            } else {
                pp.addProp("Position", INNER);
            }
        }
    }

    public Map<String, String> additionalLinkData(LinkEvent event) {
        String dstPort;
        String srcPort;
        HashMap<String, String> map = new HashMap<String, String>();
        Link link = (Link)event.subject();
        Ip4Address ipDstAddress = null;
        Ip4Address ipSrcAddress = null;
        long srcPortNo = link.src().port().toLong();
        if ((srcPortNo & 0x100000000L) == 0x100000000L) {
            srcPort = String.valueOf(srcPortNo);
        } else {
            ipSrcAddress = Ip4Address.valueOf((int)((int)srcPortNo));
            srcPort = ipSrcAddress.toString();
        }
        long dstPortNo = link.dst().port().toLong();
        if ((dstPortNo & 0x100000000L) == 0x100000000L) {
            dstPort = String.valueOf(dstPortNo);
        } else {
            ipDstAddress = Ip4Address.valueOf((int)((int)dstPortNo));
            dstPort = ipDstAddress.toString();
        }
        map.put("Src Address", srcPort);
        map.put("Dst Address", dstPort);
        map.put("Te metric", link.annotations().value(TE_METRIC));
        ResourceService resService = (ResourceService)AbstractShellCommand.get(ResourceService.class);
        DiscreteResource devResource = Resources.discrete((DeviceId)link.src().deviceId(), (PortNumber)link.src().port(), (Object[])new Object[0]).resource();
        if (resService == null) {
            this.log.warn("resource service does not exist");
            return map;
        }
        if (devResource == null) {
            this.log.warn("Device resources does not exist");
            return map;
        }
        double regBandwidth = 0.0;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            this.log.error("Exception occured while getting the bandwidth.");
        }
        Set resources = resService.getRegisteredResources(devResource.id());
        for (Resource res : resources) {
            if (!(res instanceof ContinuousResource)) continue;
            regBandwidth = ((ContinuousResource)res).value();
            break;
        }
        if (regBandwidth != 0.0) {
            String bandWidth = String.valueOf(regBandwidth);
            map.put("Bandwidth", bandWidth);
        }
        return map;
    }
}

