/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pceweb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onlab.util.DataRateUnit;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelEvent;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelListener;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pceservice.constraint.PceBandwidthConstraint;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.Mod;
import org.onosproject.ui.topo.NodeBadge;
import org.onosproject.ui.topo.TopoJson;
import org.onosproject.ui.topo.TopoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PceWebTopovMessageHandler
extends UiMessageHandler {
    private static final String PCEWEB_CLEAR = "pceTopovClear";
    private static final String PCEWEB_SET_PATH = "pceTopovSetMode";
    private static final String PCEWEB_UPDATE_PATH_QUERY = "pceTopovUpdateQuery";
    private static final String PCEWEB_UPDATE_PATH = "pceTopovUpdate";
    private static final String PCEWEB_REMOVE_PATH_QUERY = "pceTopovRemQuery";
    private static final String PCEWEB_REMOVE_PATH = "pceTopovRem";
    private static final String PCEWEB_QUERY_TUNNELS = "pceTopovTunnelDisplay";
    private static final String PCEWEB_SHOW_TUNNEL = "pceTopovShowTunnels";
    private static final String PCEWEB_SHOW_TUNNEL_REMOVE = "pceTopovShowTunnelsRem";
    private static final String PCEWEB_TUNNEL_UPDATE_INFO = "updatePathmsgInfo";
    private static final String PCEWEB_TUNNEL_UPDATE_INFO_REPLY = "pceTopovShowTunnelsUpdate";
    private static final String PCEWEB_TUNNEL_QUERY_INFO = "pceTopovShowTunnelsQuery";
    private static final String PCEWEB_TUNNEL_QUERY_INFO_SHOW = "pceTopovshowTunnelHighlightMsg";
    private static final String DST = "DST";
    private static final String SRC = "SRC";
    private static final String BANDWIDTH = "bw";
    private static final String LOADBALANCING = "lb";
    private static final String BANDWIDTHTYPE = "bwtype";
    private static final String COSTTYPE = "ctype";
    private static final String LSPTYPE = "lsptype";
    private static final String SRCID = "srid";
    private static final String DSTID = "dsid";
    private static final String TUNNEL_ID = "tunnelid";
    private static final String TUNNEL_NAME = "tunnelname";
    private static final String COST_TYPE_IGP = "igp";
    private static final String COST_TYPE_TE = "te";
    private static final String BANDWIDTH_TYPE_KBPS = "kbps";
    private static final String BANDWIDTH_TYPE_MBPS = "mbps";
    private static final String BUFFER_ARRAY = "a";
    private static final String BANDWIDTH_BPS = "BPS";
    private static final String LSP_TYPE_CR = "cr";
    private static final String LSP_TYPE_SRBE = "srbe";
    private static final String LSP_TYPE_SRTE = "srte";
    private static final String STRING_NULL = "null";
    private static final int DELAY_MS = 1100;
    private static final double BANDWIDTH_KBPS = 1000.0;
    private static final double BANDWIDTH_MBPS = 1000000.0;
    private static final String[] LINK_COLOR = new String[]{"pCol1", "pCol2", "pCol3", "pCol4", "pCol5", "pCol6", "pCol7", "pCol8", "pCol9", "pCol10", "pCol11", "pCol12", "pCol13", "pCol14", "pCol15"};
    private static final int LINK_COLOR_MAX = LINK_COLOR.length;
    private Set<Link> allPathLinks;
    private ElementId src;
    private ElementId dst;
    private List<Path> paths = new LinkedList<Path>();
    private int pathIndex;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final TunnelListener tunnelListener = new InnerPceWebTunnelListener();
    protected TopologyService topologyService;
    protected TunnelService tunnelService;
    protected PceService pceService;
    protected DeviceService deviceService;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.tunnelService = (TunnelService)directory.get(TunnelService.class);
        this.pceService = (PceService)directory.get(PceService.class);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.tunnelService.addListener((EventListener)this.tunnelListener);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new ClearHandler()), (Object)((Object)new SetPathHandler()), (Object)((Object)new UpdatePathQueryHandler()), (Object)((Object)new UpdatePathHandler()), (Object)((Object)new RemovePathQueryHandler()), (Object)((Object)new RemovePathHandler()), (Object[])new RequestHandler[]{new UpdatePathInfoHandler(), new ShowTunnelHandler(), new ShowTunnelHighlight()});
    }

    public void destroy() {
        this.tunnelService.removeListener((EventListener)this.tunnelListener);
        super.destroy();
    }

    private ElementId elementId(String id) {
        try {
            return DeviceId.deviceId((String)id);
        }
        catch (IllegalArgumentException e) {
            return HostId.hostId((String)id);
        }
    }

    private void findAndSendPaths(ElementId src, ElementId dst, String bandWidth, String bandWidthType, String costType, String lspType, String tunnelName, String loadBalancing) {
        this.log.debug("src={}; dst={};", (Object)src, (Object)dst);
        List<Constraint> listConstrnt = this.addBandwidthCostTypeConstraints(bandWidth, bandWidthType, costType);
        LspType lspTypeVal = null;
        switch (lspType) {
            case "cr": {
                lspTypeVal = LspType.WITH_SIGNALLING;
                break;
            }
            case "srbe": {
                lspTypeVal = LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR;
                break;
            }
            case "srte": {
                lspTypeVal = LspType.SR_WITHOUT_SIGNALLING;
                break;
            }
        }
        boolean loadBalancingOpt = Boolean.parseBoolean(loadBalancing);
        boolean path = loadBalancingOpt ? this.pceService.setupPath((DeviceId)src, (DeviceId)dst, tunnelName, listConstrnt, lspTypeVal, loadBalancingOpt) : this.pceService.setupPath((DeviceId)src, (DeviceId)dst, tunnelName, listConstrnt, lspTypeVal, null);
        if (!path) {
            this.log.error("setup path is failed");
        }
    }

    private void findAndSendPathsUpdate(String bandWidth, String bandWidthType, String costType, String tunnelIdStr) {
        if (tunnelIdStr != null) {
            if (tunnelIdStr.equals(STRING_NULL)) {
                this.log.error("update path is failed");
                return;
            }
            if (this.pceService == null) {
                this.log.error("PCE service is not active");
                return;
            }
            List<Constraint> listConstrnt = this.addBandwidthCostTypeConstraints(bandWidth, bandWidthType, costType);
            TunnelId tunnelId = TunnelId.valueOf((String)tunnelIdStr);
            boolean path = this.pceService.updatePath(tunnelId, listConstrnt);
            if (!path) {
                this.log.error("update path is failed");
            }
        }
    }

    private void findAndSendPathsRemove(String tunnelIdStr, String pathName) {
        boolean path;
        if (this.pceService == null) {
            this.log.error("PCE service is not active");
            return;
        }
        if (tunnelIdStr.equals(STRING_NULL) && !pathName.equals(STRING_NULL)) {
            path = this.pceService.releasePath(pathName);
        } else {
            TunnelId tunnelId = TunnelId.valueOf((String)tunnelIdStr);
            path = this.pceService.releasePath(tunnelId);
        }
        if (!path) {
            this.log.error("remove path is failed");
        }
    }

    private ImmutableSet.Builder<Link> buildPaths(ImmutableSet.Builder<Link> pathBuilder) {
        this.paths.forEach(path -> path.links().forEach(arg_0 -> ((ImmutableSet.Builder)pathBuilder).add(arg_0)));
        return pathBuilder;
    }

    private List<Constraint> addBandwidthCostTypeConstraints(String bandWidth, String bandWidthType, String costType) {
        LinkedList<Constraint> listConstrnt = new LinkedList<Constraint>();
        double bwValue = 0.0;
        if (!bandWidth.equals(STRING_NULL)) {
            bwValue = Double.parseDouble(bandWidth);
        }
        if (bandWidthType.equals(BANDWIDTH_TYPE_KBPS)) {
            bwValue *= 1000.0;
        } else if (bandWidthType.equals(BANDWIDTH_TYPE_MBPS)) {
            bwValue *= 1000000.0;
        }
        CostConstraint.Type costTypeVal = null;
        switch (costType) {
            case "igp": {
                costTypeVal = CostConstraint.Type.COST;
                break;
            }
            case "te": {
                costTypeVal = CostConstraint.Type.TE_COST;
                break;
            }
        }
        if (bwValue != 0.0) {
            listConstrnt.add((Constraint)PceBandwidthConstraint.of((double)bwValue, (DataRateUnit)DataRateUnit.valueOf((String)BANDWIDTH_BPS)));
        }
        if (costTypeVal != null) {
            listConstrnt.add((Constraint)CostConstraint.of((CostConstraint.Type)costTypeVal));
        }
        return listConstrnt;
    }

    private void hilightAndSendPaths(Highlights highlights) {
        int linkclr = 0;
        for (Path path : this.paths) {
            for (Link link : path.links()) {
                LinkHighlight lh = new LinkHighlight(TopoUtils.compactLinkString((Link)link), LinkHighlight.Flavor.PRIMARY_HIGHLIGHT).addMod(new Mod(LINK_COLOR[linkclr]));
                highlights.add(lh);
            }
            if (++linkclr != LINK_COLOR_MAX) continue;
            linkclr = 0;
        }
        this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
    }

    private Highlights addBadge(Highlights highlights, String elemId, String src) {
        highlights = this.addDeviceBadge(highlights, elemId, src);
        return highlights;
    }

    private Highlights addDeviceBadge(Highlights h, String elemId, String type) {
        DeviceHighlight dh = new DeviceHighlight(elemId);
        dh.setBadge(this.createBadge(type));
        h.add(dh);
        return h;
    }

    private NodeBadge createBadge(String type) {
        return NodeBadge.text((String)type);
    }

    private void findTunnelAndHighlights() {
        Collection tunnelSet = null;
        Highlights highlights = new Highlights();
        this.paths.removeAll(this.paths);
        tunnelSet = this.tunnelService.queryTunnel(Tunnel.Type.MPLS);
        if (tunnelSet.size() == 0) {
            this.log.warn("Tunnel does not exist");
            this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
            return;
        }
        for (Tunnel tunnel : tunnelSet) {
            Link lastLink;
            if (tunnel.path() == null) {
                this.log.error("path does not exist");
                this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
                return;
            }
            if (!tunnel.state().equals((Object)Tunnel.State.ACTIVE)) {
                this.log.debug("Tunnel state is not active");
                this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
                return;
            }
            Link firstLink = (Link)tunnel.path().links().get(0);
            if (firstLink != null && firstLink.src() != null) {
                highlights = this.addBadge(highlights, firstLink.src().deviceId().toString(), SRC);
            }
            if ((lastLink = (Link)tunnel.path().links().get(tunnel.path().links().size() - 1)) != null && lastLink.dst() != null) {
                highlights = this.addBadge(highlights, lastLink.dst().deviceId().toString(), DST);
            }
            this.paths.add(tunnel.path());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.allPathLinks = this.buildPaths((ImmutableSet.Builder<Link>)builder).build();
        this.hilightAndSendPaths(highlights);
    }

    private void highlightsForTunnel(Tunnel ... tunnels) {
        this.highlightsForTunnel(Arrays.asList(tunnels));
    }

    private void highlightsForTunnel(List<Tunnel> tunnels) {
        Highlights highlights = new Highlights();
        this.paths.removeAll(this.paths);
        if (tunnels.isEmpty()) {
            this.log.error("path does not exist");
            this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
            return;
        }
        for (Tunnel tunnel : tunnels) {
            Link lastLink;
            if (tunnel.path() == null) {
                this.log.error("path does not exist");
                this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
                return;
            }
            if (!tunnel.state().equals((Object)Tunnel.State.ACTIVE)) {
                this.log.debug("Tunnel state is not active");
                this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
                return;
            }
            Link firstLink = (Link)tunnel.path().links().get(0);
            if (firstLink != null && firstLink.src() != null) {
                highlights = this.addBadge(highlights, firstLink.src().deviceId().toString(), SRC);
            }
            if ((lastLink = (Link)tunnel.path().links().get(tunnel.path().links().size() - 1)) != null && lastLink.dst() != null) {
                highlights = this.addBadge(highlights, lastLink.dst().deviceId().toString(), DST);
            }
            this.paths.add(tunnel.path());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.allPathLinks = this.buildPaths((ImmutableSet.Builder<Link>)builder).build();
        this.hilightAndSendPaths(highlights);
    }

    private class InnerPceWebTunnelListener
    implements TunnelListener {
        private InnerPceWebTunnelListener() {
        }

        public void event(TunnelEvent event) {
            Tunnel tunnel = (Tunnel)event.subject();
            if (tunnel.type() == Tunnel.Type.MPLS) {
                PceWebTopovMessageHandler.this.highlightsForTunnel(new Tunnel[]{tunnel});
            }
        }
    }

    private final class ShowTunnelHighlight
    extends RequestHandler {
        public ShowTunnelHighlight() {
            super(PceWebTopovMessageHandler.PCEWEB_TUNNEL_QUERY_INFO_SHOW);
        }

        public void process(ObjectNode payload) {
            String tunnelIdStr = this.string(payload, PceWebTopovMessageHandler.TUNNEL_ID);
            String pathName = this.string(payload, PceWebTopovMessageHandler.TUNNEL_NAME);
            if (tunnelIdStr.equals("")) {
                LinkedList tunnels = Lists.newLinkedList();
                List tunnelIds = PceWebTopovMessageHandler.this.pceService.queryLoadBalancingPath(pathName);
                for (TunnelId id : tunnelIds) {
                    Tunnel t = PceWebTopovMessageHandler.this.tunnelService.queryTunnel(id);
                    tunnels.add(t);
                }
                if (!tunnels.isEmpty()) {
                    PceWebTopovMessageHandler.this.highlightsForTunnel(tunnels);
                }
            } else {
                TunnelId tunnelId = TunnelId.valueOf((String)tunnelIdStr);
                Tunnel t = PceWebTopovMessageHandler.this.tunnelService.queryTunnel(tunnelId);
                if (t != null) {
                    PceWebTopovMessageHandler.this.highlightsForTunnel(new Tunnel[]{t});
                }
            }
        }
    }

    private final class ShowTunnelHandler
    extends RequestHandler {
        public ShowTunnelHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_QUERY_TUNNELS);
        }

        public void process(ObjectNode payload) {
            ObjectNode result = PceWebTopovMessageHandler.this.objectNode();
            ArrayNode arrayNode = PceWebTopovMessageHandler.this.arrayNode();
            Collection tunnelSet = null;
            tunnelSet = PceWebTopovMessageHandler.this.tunnelService.queryTunnel(Tunnel.Type.MPLS);
            for (Tunnel tunnel : tunnelSet) {
                if (!tunnel.state().equals((Object)Tunnel.State.ACTIVE)) continue;
                if (tunnel.annotations().value("loadBalancingPathName") != null) {
                    boolean present = false;
                    if (arrayNode.isNull()) continue;
                    for (JsonNode node : arrayNode) {
                        if (!node.asText().equals(tunnel.annotations().value("loadBalancingPathName"))) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    arrayNode.add("");
                    arrayNode.add(tunnel.annotations().value("loadBalancingPathName"));
                    continue;
                }
                arrayNode.add(tunnel.tunnelId().toString());
                arrayNode.add(tunnel.tunnelName().toString());
            }
            result.putArray(PceWebTopovMessageHandler.BUFFER_ARRAY).addAll(arrayNode);
            this.sendMessage(PceWebTopovMessageHandler.PCEWEB_TUNNEL_QUERY_INFO, result);
        }
    }

    private final class RemovePathHandler
    extends RequestHandler {
        public RemovePathHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_REMOVE_PATH);
        }

        public void process(ObjectNode payload) {
            String tunnelId = this.string(payload, PceWebTopovMessageHandler.TUNNEL_ID);
            String pathName = this.string(payload, PceWebTopovMessageHandler.TUNNEL_NAME);
            if (tunnelId.equals("") && pathName != null) {
                PceWebTopovMessageHandler.this.findAndSendPathsRemove(PceWebTopovMessageHandler.STRING_NULL, pathName);
            } else {
                PceWebTopovMessageHandler.this.findAndSendPathsRemove(tunnelId, null);
            }
        }
    }

    private final class RemovePathQueryHandler
    extends RequestHandler {
        public RemovePathQueryHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_REMOVE_PATH_QUERY);
        }

        public void process(ObjectNode payload) {
            String srcId = this.string(payload, PceWebTopovMessageHandler.SRCID);
            ElementId src = PceWebTopovMessageHandler.this.elementId(srcId);
            String dstId = this.string(payload, PceWebTopovMessageHandler.DSTID);
            ElementId dst = PceWebTopovMessageHandler.this.elementId(dstId);
            Device srcDevice = PceWebTopovMessageHandler.this.deviceService.getDevice((DeviceId)src);
            Device dstDevice = PceWebTopovMessageHandler.this.deviceService.getDevice((DeviceId)dst);
            IpTunnelEndPoint tunSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)srcDevice.annotations().value("lsrId")));
            IpTunnelEndPoint tunDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)dstDevice.annotations().value("lsrId")));
            Collection tunnelSet = PceWebTopovMessageHandler.this.tunnelService.queryTunnel((TunnelEndPoint)tunSrc, (TunnelEndPoint)tunDst);
            ObjectNode result = PceWebTopovMessageHandler.this.objectNode();
            ArrayNode arrayNode = PceWebTopovMessageHandler.this.arrayNode();
            for (Tunnel tunnel : tunnelSet) {
                if (tunnel.type() != Tunnel.Type.MPLS || !tunnel.state().equals((Object)Tunnel.State.ACTIVE)) continue;
                if (tunnel.annotations().value("loadBalancingPathName") != null) {
                    boolean present = false;
                    if (arrayNode.isNull()) continue;
                    for (JsonNode node : arrayNode) {
                        if (!node.asText().equals(tunnel.annotations().value("loadBalancingPathName"))) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    arrayNode.add("");
                    arrayNode.add(tunnel.annotations().value("loadBalancingPathName"));
                    continue;
                }
                arrayNode.add(tunnel.tunnelId().toString());
                arrayNode.add(tunnel.tunnelName().toString());
            }
            result.putArray(PceWebTopovMessageHandler.BUFFER_ARRAY).addAll(arrayNode);
            this.sendMessage(PceWebTopovMessageHandler.PCEWEB_SHOW_TUNNEL_REMOVE, result);
        }
    }

    private final class UpdatePathInfoHandler
    extends RequestHandler {
        public UpdatePathInfoHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_TUNNEL_UPDATE_INFO);
        }

        public void process(ObjectNode payload) {
            String tunnelIdStr = this.string(payload, PceWebTopovMessageHandler.TUNNEL_ID);
            if (tunnelIdStr == null) {
                PceWebTopovMessageHandler.this.log.error("PCE update path is failed.");
                return;
            }
            if (tunnelIdStr.equals(PceWebTopovMessageHandler.STRING_NULL)) {
                PceWebTopovMessageHandler.this.log.error("PCE update path is failed.");
                return;
            }
            if (PceWebTopovMessageHandler.this.pceService == null) {
                PceWebTopovMessageHandler.this.log.error("PCE service is not active");
                return;
            }
            TunnelId tunnelId = TunnelId.valueOf((String)tunnelIdStr);
            Tunnel tunnel = PceWebTopovMessageHandler.this.tunnelService.queryTunnel(tunnelId);
            ObjectNode result = PceWebTopovMessageHandler.this.objectNode();
            ArrayNode arrayNode = PceWebTopovMessageHandler.this.arrayNode();
            arrayNode.add("Tunnel");
            arrayNode.add(tunnelIdStr);
            arrayNode.add("BandWidth");
            arrayNode.add(tunnel.annotations().value("bandwidth"));
            arrayNode.add("CostType");
            arrayNode.add(tunnel.annotations().value("costType"));
            result.putArray(PceWebTopovMessageHandler.BUFFER_ARRAY).addAll(arrayNode);
            this.sendMessage(PceWebTopovMessageHandler.PCEWEB_TUNNEL_UPDATE_INFO_REPLY, result);
        }
    }

    private final class UpdatePathHandler
    extends RequestHandler {
        public UpdatePathHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_UPDATE_PATH);
        }

        public void process(ObjectNode payload) {
            String bandWidth = this.string(payload, PceWebTopovMessageHandler.BANDWIDTH);
            String bandWidthType = this.string(payload, PceWebTopovMessageHandler.BANDWIDTHTYPE);
            String costType = this.string(payload, PceWebTopovMessageHandler.COSTTYPE);
            String tunnelId = this.string(payload, PceWebTopovMessageHandler.TUNNEL_ID);
            if (tunnelId == null) {
                PceWebTopovMessageHandler.this.log.error("PCE update path is failed.");
            }
            PceWebTopovMessageHandler.this.findAndSendPathsUpdate(bandWidth, bandWidthType, costType, tunnelId);
        }
    }

    private final class UpdatePathQueryHandler
    extends RequestHandler {
        public UpdatePathQueryHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_UPDATE_PATH_QUERY);
        }

        public void process(ObjectNode payload) {
            String srcId = this.string(payload, PceWebTopovMessageHandler.SRCID);
            ElementId src = PceWebTopovMessageHandler.this.elementId(srcId);
            String dstId = this.string(payload, PceWebTopovMessageHandler.DSTID);
            ElementId dst = PceWebTopovMessageHandler.this.elementId(dstId);
            Device srcDevice = PceWebTopovMessageHandler.this.deviceService.getDevice((DeviceId)src);
            Device dstDevice = PceWebTopovMessageHandler.this.deviceService.getDevice((DeviceId)dst);
            IpTunnelEndPoint tunSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)srcDevice.annotations().value("lsrId")));
            IpTunnelEndPoint tunDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)dstDevice.annotations().value("lsrId")));
            Collection tunnelSet = PceWebTopovMessageHandler.this.tunnelService.queryTunnel((TunnelEndPoint)tunSrc, (TunnelEndPoint)tunDst);
            ObjectNode result = PceWebTopovMessageHandler.this.objectNode();
            ArrayNode arrayNode = PceWebTopovMessageHandler.this.arrayNode();
            for (Tunnel tunnel : tunnelSet) {
                if (tunnel.type() != Tunnel.Type.MPLS || !tunnel.state().equals((Object)Tunnel.State.ACTIVE)) continue;
                arrayNode.add(tunnel.tunnelId().toString());
                arrayNode.add(tunnel.tunnelName().toString());
            }
            result.putArray(PceWebTopovMessageHandler.BUFFER_ARRAY).addAll(arrayNode);
            this.sendMessage(PceWebTopovMessageHandler.PCEWEB_SHOW_TUNNEL, result);
        }
    }

    private final class SetPathHandler
    extends RequestHandler {
        public SetPathHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_SET_PATH);
        }

        public void process(ObjectNode payload) {
            String srcId = this.string(payload, PceWebTopovMessageHandler.SRCID);
            PceWebTopovMessageHandler.this.src = PceWebTopovMessageHandler.this.elementId(srcId);
            String dstId = this.string(payload, PceWebTopovMessageHandler.DSTID);
            PceWebTopovMessageHandler.this.dst = PceWebTopovMessageHandler.this.elementId(dstId);
            if (PceWebTopovMessageHandler.this.src.equals(PceWebTopovMessageHandler.this.dst)) {
                PceWebTopovMessageHandler.this.src = null;
            }
            String bandWidth = this.string(payload, PceWebTopovMessageHandler.BANDWIDTH);
            String bandWidthType = this.string(payload, PceWebTopovMessageHandler.BANDWIDTHTYPE);
            String costType = this.string(payload, PceWebTopovMessageHandler.COSTTYPE);
            String loadBalancing = this.string(payload, PceWebTopovMessageHandler.LOADBALANCING);
            String lspType = this.string(payload, PceWebTopovMessageHandler.LSPTYPE);
            String tunnelName = this.string(payload, PceWebTopovMessageHandler.TUNNEL_NAME);
            if (tunnelName == null || tunnelName.equals(PceWebTopovMessageHandler.STRING_NULL)) {
                PceWebTopovMessageHandler.this.log.error("tunnel name should not be empty");
                return;
            }
            Collection existingTunnels = PceWebTopovMessageHandler.this.tunnelService.queryTunnel(Tunnel.Type.MPLS);
            if (existingTunnels != null) {
                for (Tunnel t : existingTunnels) {
                    if (!t.tunnelName().toString().equals(tunnelName)) continue;
                    PceWebTopovMessageHandler.this.log.error("Path creation failed, Tunnel name already exists");
                    return;
                }
            }
            if (PceWebTopovMessageHandler.this.pceService == null) {
                PceWebTopovMessageHandler.this.log.error("PCE service is not active");
                return;
            }
            if (lspType == null || lspType.equals(PceWebTopovMessageHandler.STRING_NULL)) {
                PceWebTopovMessageHandler.this.log.error("PCE setup path is failed as LSP type is mandatory");
            }
            if (PceWebTopovMessageHandler.this.src != null && PceWebTopovMessageHandler.this.dst != null) {
                PceWebTopovMessageHandler.this.findAndSendPaths(PceWebTopovMessageHandler.this.src, PceWebTopovMessageHandler.this.dst, bandWidth, bandWidthType, costType, lspType, tunnelName, loadBalancing);
            }
        }
    }

    private final class ClearHandler
    extends RequestHandler {
        public ClearHandler() {
            super(PceWebTopovMessageHandler.PCEWEB_CLEAR);
        }

        public void process(ObjectNode payload) {
            PceWebTopovMessageHandler.this.src = null;
            PceWebTopovMessageHandler.this.dst = null;
            this.sendMessage(TopoJson.highlightsMessage((Highlights)new Highlights()));
        }
    }
}

