/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetunnel.impl;

import java.util.Collection;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelAdminService;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.tetopology.management.api.TeTopology;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.TeTopologyService;
import org.onosproject.tetunnel.api.TeTunnelAdminService;
import org.onosproject.tetunnel.api.TeTunnelProviderService;
import org.onosproject.tetunnel.api.TeTunnelService;
import org.onosproject.tetunnel.api.TeTunnelStore;
import org.onosproject.tetunnel.api.lsp.TeLsp;
import org.onosproject.tetunnel.api.lsp.TeLspKey;
import org.onosproject.tetunnel.api.tunnel.TeTunnel;
import org.onosproject.tetunnel.api.tunnel.TeTunnelEndpoint;
import org.onosproject.tetunnel.api.tunnel.TeTunnelKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class TeTunnelManager
implements TeTunnelService,
TeTunnelAdminService,
TeTunnelProviderService {
    private static final String TE_TUNNEL_APP = "onos-app-tetunnel";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TeTunnelStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelService tunnelService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelAdminService tunnelAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TeTopologyService teTopologyService;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(TE_TUNNEL_APP);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public TunnelId createTeTunnel(TeTunnel teTunnel) {
        DeviceId domainId;
        TunnelId id;
        if (!this.store.addTeTunnel(teTunnel)) {
            this.log.error("can not add teTunnel: {}", (Object)teTunnel);
            return null;
        }
        TunnelId tunnelId = TunnelId.valueOf((String)teTunnel.teTunnelKey().toString());
        DefaultTunnel tunnel = new DefaultTunnel(ProviderId.NONE, (TunnelEndPoint)new TeTunnelEndpoint(teTunnel.srcNode(), teTunnel.srcTp()), (TunnelEndPoint)new TeTunnelEndpoint(teTunnel.dstNode(), teTunnel.dstTp()), Tunnel.Type.MPLS, new GroupId(0), tunnelId, TunnelName.tunnelName((String)teTunnel.name()), null, new Annotations[]{DefaultAnnotations.builder().build()});
        this.store.setTunnelId(teTunnel.teTunnelKey(), tunnelId);
        TeTopology srcTopology = this.teTopologyService.teTopology(this.teTopologyService.teNode(teTunnel.srcNode()).underlayTeTopologyId());
        if (srcTopology == null) {
            srcTopology = this.teTopologyService.teTopology(teTunnel.srcNode().teTopologyKey());
        }
        if ((id = this.tunnelService.setupTunnel(this.appId, (ElementId)(domainId = srcTopology.ownerId()), (Tunnel)tunnel, null)) == null) {
            this.log.error("can not create tunnel for te {}", (Object)teTunnel.teTunnelKey());
            this.store.removeTeTunnel(teTunnel.teTunnelKey());
            return null;
        }
        if (!id.equals((Object)tunnelId)) {
            this.log.error("tunnelId changed, oldId:{}, newId:{}", (Object)tunnelId, (Object)id);
            this.store.setTunnelId(teTunnel.teTunnelKey(), id);
        }
        return id;
    }

    public void setTunnelId(TeTunnelKey teTunnelKey, TunnelId tunnelId) {
        this.store.setTunnelId(teTunnelKey, tunnelId);
    }

    public void updateTeTunnel(TeTunnel teTunnel) {
    }

    public void updateTunnelState(TeTunnelKey key, Tunnel.State state) {
        this.tunnelAdminService.updateTunnelState(this.tunnelService.queryTunnel(this.getTunnelId(key)), state);
    }

    public TeLspKey teLspAdded(TeLsp lsp) {
        if (this.store.addTeLsp(lsp)) {
            return lsp.teLspKey();
        }
        return null;
    }

    public void teLspRemoved(TeLsp lsp) {
        this.store.removeTeLsp(lsp.teLspKey());
    }

    public void updateTeLsp(TeLsp lsp) {
        this.store.updateTeLsp(lsp);
    }

    public void removeTeTunnel(TeTunnelKey teTunnelKey) {
        this.tunnelAdminService.updateTunnelState(this.tunnelService.queryTunnel(this.getTunnelId(teTunnelKey)), Tunnel.State.REMOVING);
        List segmentTunnels = this.getTeTunnel(teTunnelKey).segmentTunnels();
        if (segmentTunnels == null || segmentTunnels.isEmpty()) {
            this.tunnelAdminService.removeTunnel(this.getTunnelId(teTunnelKey));
        }
    }

    public void setSegmentTunnel(TeTunnelKey e2eTunnelKey, List<TeTunnelKey> segmentTunnels) {
        TeTunnel e2eTunnel = this.store.getTeTunnel(e2eTunnelKey);
        if (e2eTunnel == null) {
            this.log.error("unknown e2eTunnelKey: {}", (Object)e2eTunnelKey);
            return;
        }
        e2eTunnel.segmentTunnels(segmentTunnels);
        for (TeTunnelKey key : segmentTunnels) {
            TeTunnel segmentTunnel = this.store.getTeTunnel(key);
            if (segmentTunnel == null) {
                this.log.warn("unknown segmentTunnel: {}", (Object)key);
                continue;
            }
            segmentTunnel.e2eTunnelKey(e2eTunnelKey);
        }
    }

    public TeTunnel getTeTunnel(TeTunnelKey key) {
        return this.store.getTeTunnel(key);
    }

    public TeTunnel getTeTunnel(TunnelId id) {
        return this.store.getTeTunnel(id);
    }

    public TunnelId getTunnelId(TeTunnelKey key) {
        return this.store.getTunnelId(key);
    }

    public Collection<TeTunnel> getTeTunnels() {
        return this.store.getTeTunnels();
    }

    public Collection<TeTunnel> getTeTunnels(TeTunnel.Type type) {
        return this.store.getTeTunnels(type);
    }

    public Collection<TeTunnel> getTeTunnels(TeTopologyKey key) {
        return this.store.getTeTunnels(key);
    }

    public TeLsp getTeLsp(TeLspKey key) {
        return this.store.getTeLsp(key);
    }

    public Collection<TeLsp> getTeLsps() {
        return this.store.getTeLsps();
    }

    public TunnelId teTunnelAdded(TeTunnel teTunnel) {
        return null;
    }

    public void teTunnelRemoved(TeTunnel teTunnel) {
        TeTunnelKey e2eTunnelKey = teTunnel.e2eTunnelKey();
        this.store.removeTeTunnel(teTunnel.teTunnelKey());
        if (e2eTunnelKey != null) {
            boolean finished = true;
            for (TeTunnelKey key : this.getTeTunnel(e2eTunnelKey).segmentTunnels()) {
                if (this.getTeTunnel(key) == null) continue;
                finished = false;
            }
            if (finished) {
                this.tunnelAdminService.removeTunnel(this.getTunnelId(e2eTunnelKey));
                this.store.removeTeTunnel(e2eTunnelKey);
            }
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStore(TeTunnelStore teTunnelStore) {
        this.store = teTunnelStore;
    }

    protected void unbindStore(TeTunnelStore teTunnelStore) {
        if (this.store == teTunnelStore) {
            this.store = null;
        }
    }

    protected void bindTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    protected void unbindTunnelService(TunnelService tunnelService) {
        if (this.tunnelService == tunnelService) {
            this.tunnelService = null;
        }
    }

    protected void bindTunnelAdminService(TunnelAdminService tunnelAdminService) {
        this.tunnelAdminService = tunnelAdminService;
    }

    protected void unbindTunnelAdminService(TunnelAdminService tunnelAdminService) {
        if (this.tunnelAdminService == tunnelAdminService) {
            this.tunnelAdminService = null;
        }
    }

    protected void bindTeTopologyService(TeTopologyService teTopologyService) {
        this.teTopologyService = teTopologyService;
    }

    protected void unbindTeTopologyService(TeTopologyService teTopologyService) {
        if (this.teTopologyService == teTopologyService) {
            this.teTopologyService = null;
        }
    }
}

