/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetunnel.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.StorageService;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetunnel.api.TeTunnelStore;
import org.onosproject.tetunnel.api.lsp.TeLsp;
import org.onosproject.tetunnel.api.lsp.TeLspKey;
import org.onosproject.tetunnel.api.tunnel.TeTunnel;
import org.onosproject.tetunnel.api.tunnel.TeTunnelKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedTeTunnelStore
implements TeTunnelStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;
    private EventuallyConsistentMap<TeTunnelKey, TeTunnel> teTunnels;
    private EventuallyConsistentMap<TeTunnelKey, TunnelId> tunnelIds;
    private EventuallyConsistentMap<TeLspKey, TeLsp> lsps;

    @Activate
    public void activate() {
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).nextId(500).register(new Class[]{TeTunnel.class});
        this.teTunnels = this.storageService.eventuallyConsistentMapBuilder().withName("TeTunnelStore").withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.tunnelIds = this.storageService.eventuallyConsistentMapBuilder().withName("TeTunnelIdStore").withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.lsps = this.storageService.eventuallyConsistentMapBuilder().withName("TeLspStore").withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.teTunnels.destroy();
        this.tunnelIds.destroy();
        this.lsps.destroy();
        this.log.info("Stopped");
    }

    public boolean addTeTunnel(TeTunnel teTunnel) {
        if (teTunnel == null) {
            this.log.warn("teTunnel is null");
            return false;
        }
        if (this.teTunnels.containsKey((Object)teTunnel.teTunnelKey())) {
            this.log.warn("teTunnel already exist");
            return false;
        }
        this.teTunnels.put((Object)teTunnel.teTunnelKey(), (Object)teTunnel);
        return true;
    }

    public void setTunnelId(TeTunnelKey teTunnelKey, TunnelId tunnelId) {
        this.tunnelIds.put((Object)teTunnelKey, (Object)tunnelId);
    }

    public TunnelId getTunnelId(TeTunnelKey teTunnelKey) {
        return (TunnelId)this.tunnelIds.get((Object)teTunnelKey);
    }

    public void updateTeTunnel(TeTunnel teTunnel) {
        if (teTunnel == null) {
            this.log.warn("TeTunnel is null");
            return;
        }
        this.teTunnels.put((Object)teTunnel.teTunnelKey(), (Object)teTunnel);
    }

    public void removeTeTunnel(TeTunnelKey teTunnelKey) {
        this.teTunnels.remove((Object)teTunnelKey);
        this.tunnelIds.remove((Object)teTunnelKey);
    }

    public TeTunnel getTeTunnel(TeTunnelKey teTunnelKey) {
        return (TeTunnel)this.teTunnels.get((Object)teTunnelKey);
    }

    public TeTunnel getTeTunnel(TunnelId tunnelId) {
        if (this.tunnelIds.containsValue((Object)tunnelId)) {
            for (TeTunnel teTunnel : this.teTunnels.values()) {
                if (!((TunnelId)this.tunnelIds.get((Object)teTunnel.teTunnelKey())).equals((Object)tunnelId)) continue;
                return teTunnel;
            }
        }
        return null;
    }

    public Collection<TeTunnel> getTeTunnels() {
        return ImmutableList.copyOf((Collection)this.teTunnels.values());
    }

    public Collection<TeTunnel> getTeTunnels(TeTunnel.Type type) {
        return ImmutableList.copyOf((Collection)this.teTunnels.values().stream().filter(teTunnel -> teTunnel.type().equals((Object)type)).collect(Collectors.toList()));
    }

    public Collection<TeTunnel> getTeTunnels(TeTopologyKey teTopologyKey) {
        return ImmutableList.copyOf((Collection)this.teTunnels.values().stream().filter(teTunnel -> teTunnel.teTunnelKey().teTopologyKey().equals((Object)teTopologyKey)).collect(Collectors.toList()));
    }

    public boolean addTeLsp(TeLsp lsp) {
        if (lsp == null) {
            this.log.warn("TeLsp is null");
            return false;
        }
        if (this.lsps.containsKey((Object)lsp.teLspKey())) {
            this.log.error("TeLsp exist {}", (Object)lsp.teLspKey());
            return false;
        }
        this.lsps.put((Object)lsp.teLspKey(), (Object)lsp);
        return true;
    }

    public void updateTeLsp(TeLsp lsp) {
        if (lsp == null) {
            this.log.warn("TeLsp is null");
            return;
        }
        this.lsps.put((Object)lsp.teLspKey(), (Object)lsp);
    }

    public void removeTeLsp(TeLspKey key) {
        this.lsps.remove((Object)key);
    }

    public TeLsp getTeLsp(TeLspKey key) {
        return (TeLsp)this.lsps.get((Object)key);
    }

    public Collection<TeLsp> getTeLsps() {
        return ImmutableList.copyOf((Collection)this.lsps.values());
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }
}

