/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebAppDependencyHolder;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppPublisher.class);
    private final Map<WebApp, ServiceTracker<WebAppDependencyHolder, WebAppDependencyHolder>> webApps = Collections.synchronizedMap(new HashMap());
    private final WebEventDispatcher eventDispatcher;
    private final BundleContext bundleContext;

    WebAppPublisher(WebEventDispatcher eventDispatcher, BundleContext bundleContext) {
        this.eventDispatcher = eventDispatcher;
        this.bundleContext = bundleContext;
    }

    public void publish(WebApp webApp) {
        NullArgumentException.validateNotNull(webApp, "Web app");
        LOG.debug("Publishing web application [{}]", (Object)webApp);
        BundleContext webAppBundleContext = BundleUtils.getBundleContext(webApp.getBundle());
        if (webAppBundleContext != null) {
            try {
                Filter filter = webAppBundleContext.createFilter(String.format("(&(objectClass=%s)(bundle.id=%d))", WebAppDependencyHolder.class.getName(), webApp.getBundle().getBundleId()));
                ServiceTracker dependencyTracker = new ServiceTracker(webAppBundleContext, filter, (ServiceTrackerCustomizer)new WebAppDependencyListener(webApp, this.eventDispatcher, this.bundleContext));
                this.webApps.put(webApp, (ServiceTracker<WebAppDependencyHolder, WebAppDependencyHolder>)dependencyTracker);
                dependencyTracker.open();
            }
            catch (InvalidSyntaxException exc) {
                throw new IllegalArgumentException(exc);
            }
        } else {
            LOG.warn("Bundle context could not be discovered for bundle [" + webApp.getBundle() + "]" + "Skipping publishing of web application [" + webApp + "]");
        }
    }

    public void unpublish(WebApp webApp) {
        NullArgumentException.validateNotNull(webApp, "Web app");
        LOG.debug("Unpublishing web application [{}]", (Object)webApp);
        ServiceTracker<WebAppDependencyHolder, WebAppDependencyHolder> tracker = this.webApps.remove(webApp);
        if (tracker != null) {
            tracker.close();
        }
    }

    public static class WebAppDependencyListener
    implements ServiceTrackerCustomizer<WebAppDependencyHolder, WebAppDependencyHolder> {
        private final WebApp webApp;
        private final WebEventDispatcher eventDispatcher;
        private BundleContext bundleContext;
        private HttpService httpService;
        private WebAppDependencyHolder dependencyHolder;

        WebAppDependencyListener(WebApp webApp, WebEventDispatcher eventDispatcher, BundleContext bundleContext) {
            NullArgumentException.validateNotNull(webApp, "Web app");
            this.webApp = webApp;
            this.eventDispatcher = eventDispatcher;
            this.bundleContext = bundleContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WebAppDependencyHolder addingService(ServiceReference<WebAppDependencyHolder> reference) {
            LOG.debug("Adding service for service reference {}", reference);
            WebAppDependencyHolder dependencyHolder = (WebAppDependencyHolder)this.bundleContext.getService(reference);
            HttpService httpService = dependencyHolder.getHttpService();
            WebAppDependencyListener webAppDependencyListener = this;
            synchronized (webAppDependencyListener) {
                this.dependencyHolder = dependencyHolder;
                this.httpService = httpService;
            }
            this.register(dependencyHolder, httpService);
            return dependencyHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference<WebAppDependencyHolder> reference, WebAppDependencyHolder service) {
            HttpService oldHttpService;
            WebAppDependencyHolder oldDependencyHolder;
            LOG.debug("modified Service for service reference {}", reference);
            WebAppDependencyHolder newDependencyHolder = (WebAppDependencyHolder)this.bundleContext.getService(reference);
            HttpService newHttpService = newDependencyHolder.getHttpService();
            WebAppDependencyListener webAppDependencyListener = this;
            synchronized (webAppDependencyListener) {
                oldDependencyHolder = this.dependencyHolder;
                oldHttpService = this.httpService;
                this.dependencyHolder = newDependencyHolder;
                this.httpService = newHttpService;
            }
            this.unregister(oldDependencyHolder, oldHttpService);
            this.register(newDependencyHolder, newHttpService);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<WebAppDependencyHolder> reference, WebAppDependencyHolder service) {
            HttpService httpService;
            WebAppDependencyHolder dependencyHolder;
            WebAppDependencyListener webAppDependencyListener = this;
            synchronized (webAppDependencyListener) {
                dependencyHolder = this.dependencyHolder;
                httpService = this.httpService;
                this.dependencyHolder = null;
                this.httpService = null;
            }
            this.unregister(dependencyHolder, httpService);
        }

        private void register(WebAppDependencyHolder dependencyHolder, HttpService httpService) {
            if (httpService != null) {
                LOG.debug("Registering web application [{}] from http service [{}]", (Object)this.webApp, (Object)httpService);
                try {
                    if (WebContainerUtils.webContainerAvailable(httpService)) {
                        this.webApp.accept(new RegisterWebAppVisitorWC(dependencyHolder));
                    } else {
                        this.webApp.accept(new RegisterWebAppVisitorHS(httpService));
                    }
                    this.webApp.setDeploymentState(2);
                    this.eventDispatcher.webEvent(this.webApp, 2, httpService);
                }
                catch (Exception e) {
                    LOG.error("Error deploying web application", (Throwable)e);
                    this.eventDispatcher.webEvent(this.webApp, 5, e);
                }
            }
        }

        private void unregister(WebAppDependencyHolder dependencyHolder, HttpService httpService) {
            if (httpService != null) {
                try {
                    LOG.debug("Unregistering web application [{}] from http service [{}]", (Object)this.webApp, (Object)httpService);
                    if (WebContainerUtils.webContainerAvailable(httpService)) {
                        this.webApp.accept(new UnregisterWebAppVisitorWC((WebContainer)httpService));
                    } else {
                        this.webApp.accept(new UnregisterWebAppVisitorHS(httpService));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error undeploying web application", (Throwable)e);
                }
            }
        }
    }
}

