/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sdnip.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.sdnip.config.SdnIpConfig;

@Command(scope="onos", name="sdnip", description="Manages the SDN-IP application")
public class SdnIpCommand
extends AbstractShellCommand {
    private static final String BOLD = "\u001b[1m";
    private static final String COLOR_ERROR = "\u001b[31m";
    private static final String RESET = "\u001b[0m";
    private static final String ENCAP_NOT_FOUND = "\u001b[31mEncapsulation type \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    private static final String SDNIP_COMMAND_NOT_FOUND = "\u001b[31mSDN-IP command \u001b[1m%s\u001b[0m\u001b[31m not found\u001b[0m";
    @Argument(index=0, name="command", description="Command name {set-encap}", required=true, multiValued=false)
    String command = null;
    @Argument(index=1, name="encapType", description="The encapsulation type {NONE | VLAN | MPLS}", required=true, multiValued=false)
    String encapType = null;

    protected void execute() {
        if (this.command != null) {
            switch (this.command) {
                case "set-encap": {
                    this.setEncap(this.encapType);
                    break;
                }
                default: {
                    this.print(SDNIP_COMMAND_NOT_FOUND, new Object[]{this.command});
                }
            }
        }
    }

    private void setEncap(String encap) {
        EncapsulationType encapType = EncapsulationType.enumFromString((String)encap);
        if (encapType.equals((Object)EncapsulationType.NONE) && !encapType.toString().equals(encap)) {
            this.print(ENCAP_NOT_FOUND, new Object[]{encap});
            return;
        }
        NetworkConfigService configService = (NetworkConfigService)SdnIpCommand.get(NetworkConfigService.class);
        CoreService coreService = (CoreService)SdnIpCommand.get(CoreService.class);
        ApplicationId appId = coreService.getAppId("org.onosproject.sdnip");
        SdnIpConfig config = (SdnIpConfig)configService.addConfig((Object)appId, SdnIpConfig.class);
        config.setEncap(encapType);
        config.apply();
    }
}

