/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sdnip;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteListener;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.intentsync.IntentSynchronizationService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.net.intent.constraint.PartialFailureConstraint;
import org.onosproject.sdnip.config.SdnIpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
public class SdnIpFib {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentSynchronizationService intentSynchronizer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteService routeService;
    private final InternalRouteListener routeListener = new InternalRouteListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private final InternalNetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();
    private static final int PRIORITY_OFFSET = 100;
    private static final int PRIORITY_MULTIPLIER = 5;
    protected static final ImmutableList<Constraint> CONSTRAINTS = ImmutableList.of((Object)new PartialFailureConstraint());
    private final Map<IpPrefix, MultiPointToSinglePointIntent> routeIntents = new ConcurrentHashMap<IpPrefix, MultiPointToSinglePointIntent>();
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.getAppId("org.onosproject.sdnip");
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.routeService.addListener((EventListener)this.routeListener);
    }

    @Deactivate
    public void deactivate() {
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
        this.routeService.removeListener((EventListener)this.routeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ResolvedRoute route) {
        SdnIpFib sdnIpFib = this;
        synchronized (sdnIpFib) {
            IpPrefix prefix = route.prefix();
            EncapsulationType encap = this.encap();
            MultiPointToSinglePointIntent intent = this.generateRouteIntent(prefix, route.nextHop(), route.nextHopMac(), encap);
            if (intent == null) {
                this.log.debug("No interface found for route {}", (Object)route);
                return;
            }
            this.routeIntents.put(prefix, intent);
            this.intentSynchronizer.submit((Intent)intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withdraw(ResolvedRoute route) {
        SdnIpFib sdnIpFib = this;
        synchronized (sdnIpFib) {
            IpPrefix prefix = route.prefix();
            MultiPointToSinglePointIntent intent = this.routeIntents.remove(prefix);
            if (intent == null) {
                this.log.trace("No intent in routeIntents to delete for prefix: {}", (Object)prefix);
                return;
            }
            this.intentSynchronizer.withdraw((Intent)intent);
        }
    }

    private MultiPointToSinglePointIntent generateRouteIntent(IpPrefix prefix, IpAddress nextHopIpAddress, MacAddress nextHopMacAddress, EncapsulationType encap) {
        Interface egressInterface = this.interfaceService.getMatchingInterface(nextHopIpAddress);
        if (egressInterface == null) {
            this.log.warn("No outgoing interface found for {}", (Object)nextHopIpAddress);
            return null;
        }
        ConnectPoint egressPort = egressInterface.connectPoint();
        this.log.debug("Generating intent for prefix {}, next hop mac {}", (Object)prefix, (Object)nextHopMacAddress);
        HashSet ingressFilteredCPs = Sets.newHashSet();
        this.interfaceService.getInterfaces().forEach(intf -> {
            if (this.validIngressIntf((Interface)intf, egressInterface)) {
                TrafficSelector.Builder selector = this.buildIngressTrafficSelector((Interface)intf, prefix);
                FilteredConnectPoint ingressFilteredCP = new FilteredConnectPoint(intf.connectPoint(), selector.build());
                ingressFilteredCPs.add(ingressFilteredCP);
            }
        });
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder().setEthDst(nextHopMacAddress);
        TrafficSelector.Builder selector = this.buildTrafficSelector(egressInterface);
        FilteredConnectPoint egressFilteredCP = new FilteredConnectPoint(egressPort, selector.build());
        int priority = prefix.prefixLength() * 5 + 100;
        Key key = Key.of((String)prefix.toString(), (ApplicationId)this.appId);
        MultiPointToSinglePointIntent.Builder intentBuilder = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).filteredIngressPoints((Set)ingressFilteredCPs).filteredEgressPoint(egressFilteredCP).treatment(treatment.build()).priority(priority).constraints(CONSTRAINTS);
        SdnIpFib.setEncap((ConnectivityIntent.Builder)intentBuilder, CONSTRAINTS, encap);
        return intentBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInterface(Interface intf) {
        SdnIpFib sdnIpFib = this;
        synchronized (sdnIpFib) {
            for (Map.Entry<IpPrefix, MultiPointToSinglePointIntent> entry : this.routeIntents.entrySet()) {
                IpPrefix prefix = entry.getKey();
                MultiPointToSinglePointIntent intent = entry.getValue();
                HashSet ingressFilteredCPs = Sets.newHashSet((Iterable)intent.filteredIngressPoints());
                TrafficSelector.Builder selector = this.buildIngressTrafficSelector(intf, prefix);
                FilteredConnectPoint newIngressFilteredCP = new FilteredConnectPoint(intf.connectPoint(), selector.build());
                ingressFilteredCPs.add(newIngressFilteredCP);
                MultiPointToSinglePointIntent newIntent = MultiPointToSinglePointIntent.builder((MultiPointToSinglePointIntent)intent).filteredIngressPoints((Set)ingressFilteredCPs).build();
                this.routeIntents.put(entry.getKey(), newIntent);
                this.intentSynchronizer.submit((Intent)newIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInterface(Interface intf) {
        SdnIpFib sdnIpFib = this;
        synchronized (sdnIpFib) {
            for (Map.Entry<IpPrefix, MultiPointToSinglePointIntent> entry : this.routeIntents.entrySet()) {
                IpPrefix prefix = entry.getKey();
                MultiPointToSinglePointIntent intent = entry.getValue();
                TrafficSelector.Builder ingressSelector = this.buildIngressTrafficSelector(intf, prefix);
                FilteredConnectPoint removedIngressFilteredCP = new FilteredConnectPoint(intf.connectPoint(), ingressSelector.build());
                TrafficSelector.Builder selector = this.buildTrafficSelector(intf);
                FilteredConnectPoint removedEgressFilteredCP = new FilteredConnectPoint(intf.connectPoint(), selector.build());
                if (intent.filteredEgressPoint().equals((Object)removedEgressFilteredCP)) {
                    this.intentSynchronizer.withdraw((Intent)this.routeIntents.remove(entry.getKey()));
                    continue;
                }
                if (!intent.filteredIngressPoints().contains(removedIngressFilteredCP)) continue;
                HashSet ingressFilteredCPs = Sets.newHashSet((Iterable)intent.filteredIngressPoints());
                ingressFilteredCPs.remove(removedIngressFilteredCP);
                if (!ingressFilteredCPs.isEmpty()) {
                    MultiPointToSinglePointIntent newIntent = MultiPointToSinglePointIntent.builder((MultiPointToSinglePointIntent)intent).filteredIngressPoints((Set)ingressFilteredCPs).build();
                    this.routeIntents.put(entry.getKey(), newIntent);
                    this.intentSynchronizer.submit((Intent)newIntent);
                    continue;
                }
                this.intentSynchronizer.withdraw((Intent)this.routeIntents.remove(entry.getKey()));
            }
        }
    }

    private TrafficSelector.Builder buildIngressTrafficSelector(Interface intf, IpPrefix prefix) {
        TrafficSelector.Builder selector = this.buildTrafficSelector(intf);
        if (prefix.isIp4()) {
            selector.matchEthType(Ethernet.TYPE_IPV4);
            if (prefix.prefixLength() != 0) {
                selector.matchIPDst(prefix);
            }
        } else {
            selector.matchEthType(Ethernet.TYPE_IPV6);
            if (prefix.prefixLength() != 0) {
                selector.matchIPv6Dst(prefix);
            }
        }
        return selector;
    }

    private TrafficSelector.Builder buildTrafficSelector(Interface intf) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        VlanId vlanId = intf.vlan();
        if (!vlanId.equals((Object)VlanId.NONE)) {
            selector.matchVlanId(vlanId);
        }
        return selector;
    }

    private boolean validIngressIntf(Interface intf, Interface egressInterface) {
        return !intf.equals((Object)egressInterface) && !intf.ipAddressesList().isEmpty() && !intf.connectPoint().equals((Object)egressInterface.connectPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encapUpdate() {
        SdnIpFib sdnIpFib = this;
        synchronized (sdnIpFib) {
            EncapsulationType encap = this.encap();
            for (Map.Entry<IpPrefix, MultiPointToSinglePointIntent> entry : this.routeIntents.entrySet()) {
                MultiPointToSinglePointIntent intent = entry.getValue();
                List constraints = intent.constraints();
                if (constraints.stream().filter(c -> c instanceof EncapsulationConstraint && new EncapsulationConstraint(encap).equals(c)).findAny().isPresent()) continue;
                MultiPointToSinglePointIntent.Builder intentBuilder = MultiPointToSinglePointIntent.builder((MultiPointToSinglePointIntent)intent);
                SdnIpFib.setEncap((ConnectivityIntent.Builder)intentBuilder, constraints, encap);
                MultiPointToSinglePointIntent newIntent = intentBuilder.build();
                this.routeIntents.put(entry.getKey(), newIntent);
                this.intentSynchronizer.submit((Intent)newIntent);
            }
        }
    }

    private static void setEncap(ConnectivityIntent.Builder builder, List<Constraint> constraints, EncapsulationType encap) {
        ArrayList<Constraint> newConstraints = new ArrayList<Constraint>(constraints);
        constraints.stream().filter(c -> c instanceof EncapsulationConstraint).forEach(c -> newConstraints.remove(c));
        if (!encap.equals((Object)EncapsulationType.NONE)) {
            newConstraints.add((Constraint)new EncapsulationConstraint(encap));
        }
        builder.constraints((List)ImmutableList.copyOf(newConstraints));
    }

    private EncapsulationType encap() {
        SdnIpConfig sdnIpConfig = (SdnIpConfig)this.networkConfigService.getConfig((Object)this.appId, SdnIpConfig.class);
        if (sdnIpConfig == null) {
            this.log.debug("No SDN-IP config available");
            return EncapsulationType.NONE;
        }
        return sdnIpConfig.encap();
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        this.intentSynchronizer = intentSynchronizationService;
    }

    protected void unbindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        if (this.intentSynchronizer == intentSynchronizationService) {
            this.intentSynchronizer = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindRouteService(RouteService routeService) {
        this.routeService = routeService;
    }

    protected void unbindRouteService(RouteService routeService) {
        if (this.routeService == routeService) {
            this.routeService = null;
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: {
                    SdnIpFib.this.addInterface((Interface)event.subject());
                    break;
                }
                case INTERFACE_UPDATED: {
                    SdnIpFib.this.removeInterface(event.prevSubject());
                    SdnIpFib.this.addInterface((Interface)event.subject());
                    break;
                }
                case INTERFACE_REMOVED: {
                    SdnIpFib.this.removeInterface((Interface)event.subject());
                    break;
                }
            }
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_REGISTERED: {
                    break;
                }
                case CONFIG_UNREGISTERED: {
                    break;
                }
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: 
                case CONFIG_REMOVED: {
                    if (event.configClass() != SdnIpConfig.class) break;
                    SdnIpFib.this.encapUpdate();
                    break;
                }
            }
        }
    }

    private class InternalRouteListener
    implements RouteListener {
        private InternalRouteListener() {
        }

        public void event(RouteEvent event) {
            switch ((RouteEvent.Type)event.type()) {
                case ROUTE_ADDED: 
                case ROUTE_UPDATED: {
                    SdnIpFib.this.update((ResolvedRoute)event.subject());
                    break;
                }
                case ROUTE_REMOVED: {
                    SdnIpFib.this.withdraw((ResolvedRoute)event.subject());
                    break;
                }
            }
        }
    }
}

