/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sdnip;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.app.ApplicationService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.component.ComponentService;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.intentsync.IntentSynchronizationService;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.sdnip.PeerConnectivityManager;
import org.onosproject.sdnip.SdnIpFib;
import org.onosproject.sdnip.config.SdnIpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SdnIp {
    public static final String SDN_IP_APP = "org.onosproject.sdnip";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationService applicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentSynchronizationService intentSynchronizer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentService componentService;
    private PeerConnectivityManager peerConnectivity;
    private ApplicationId appId;
    private final List<String> components = ImmutableList.of((Object)"org.onosproject.routing.bgp.BgpSessionManager", (Object)"org.onosproject.routing.impl.BgpSpeakerNeighbourHandler", (Object)SdnIpFib.class.getName());
    private final List<ConfigFactory<?, ?>> factories = ImmutableList.of((Object)new ConfigFactory<ApplicationId, SdnIpConfig>(SubjectFactories.APP_SUBJECT_FACTORY, SdnIpConfig.class, "sdnip"){

        public SdnIpConfig createConfig() {
            return new SdnIpConfig();
        }
    });

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(SDN_IP_APP);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).registerConfigFactory(arg_0));
        this.components.forEach(name -> this.componentService.activate(this.appId, name));
        this.peerConnectivity = new PeerConnectivityManager(this.appId, this.intentSynchronizer, this.networkConfigService, this.coreService.registerApplication("org.onosproject.router"), this.interfaceService);
        this.peerConnectivity.start();
        this.applicationService.registerDeactivateHook(this.appId, () -> this.intentSynchronizer.removeIntentsByAppId(this.appId));
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.components.forEach(name -> this.componentService.deactivate(this.appId, name));
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).unregisterConfigFactory(arg_0));
        this.peerConnectivity.stop();
        this.log.info("Stopped");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    protected void unbindApplicationService(ApplicationService applicationService) {
        if (this.applicationService == applicationService) {
            this.applicationService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        this.intentSynchronizer = intentSynchronizationService;
    }

    protected void unbindIntentSynchronizer(IntentSynchronizationService intentSynchronizationService) {
        if (this.intentSynchronizer == intentSynchronizationService) {
            this.intentSynchronizer = null;
        }
    }

    protected void bindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgRegistry = networkConfigRegistry;
    }

    protected void unbindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgRegistry == networkConfigRegistry) {
            this.cfgRegistry = null;
        }
    }

    protected void bindComponentService(ComponentService componentService) {
        this.componentService = componentService;
    }

    protected void unbindComponentService(ComponentService componentService) {
        if (this.componentService == componentService) {
            this.componentService = null;
        }
    }
}

