/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sdnip;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.intentsync.IntentSynchronizationService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.EncapsulationType;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentUtils;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.constraint.EncapsulationConstraint;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.BgpConfig;
import org.onosproject.sdnip.config.SdnIpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnectivityManager {
    private static final int PRIORITY_OFFSET = 1000;
    private static final String SUFFIX_DST = "dst";
    private static final String SUFFIX_SRC = "src";
    private static final String SUFFIX_ICMP = "icmp";
    private static final Logger log = LoggerFactory.getLogger(PeerConnectivityManager.class);
    private static final short BGP_PORT = 179;
    private final IntentSynchronizationService intentSynchronizer;
    private final NetworkConfigService configService;
    private final InterfaceService interfaceService;
    private final ApplicationId appId;
    private final ApplicationId routerAppId;
    private final Map<Key, PointToPointIntent> peerIntents;
    private final InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();

    public PeerConnectivityManager(ApplicationId appId, IntentSynchronizationService intentSynchronizer, NetworkConfigService configService, ApplicationId routerAppId, InterfaceService interfaceService) {
        this.appId = appId;
        this.intentSynchronizer = intentSynchronizer;
        this.configService = configService;
        this.routerAppId = routerAppId;
        this.interfaceService = interfaceService;
        this.peerIntents = new HashMap<Key, PointToPointIntent>();
    }

    public void start() {
        this.configService.addListener((EventListener)this.configListener);
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.setUpConnectivity();
    }

    public void stop() {
        this.configService.removeListener((EventListener)this.configListener);
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
    }

    private void setUpConnectivity() {
        EncapsulationType encap;
        Set<BgpConfig.BgpSpeakerConfig> bgpSpeakers;
        BgpConfig bgpConfig = (BgpConfig)this.configService.getConfig((Object)this.routerAppId, RoutingService.CONFIG_CLASS);
        SdnIpConfig sdnIpConfig = (SdnIpConfig)this.configService.getConfig((Object)this.appId, SdnIpConfig.class);
        if (bgpConfig == null) {
            log.debug("No BGP config available");
            bgpSpeakers = Collections.emptySet();
        } else {
            bgpSpeakers = bgpConfig.bgpSpeakers();
        }
        if (sdnIpConfig == null) {
            log.debug("No SDN-IP config available");
            encap = EncapsulationType.NONE;
        } else {
            encap = sdnIpConfig.encap();
        }
        HashMap<Key, PointToPointIntent> existingIntents = new HashMap<Key, PointToPointIntent>(this.peerIntents);
        for (BgpConfig.BgpSpeakerConfig bgpSpeaker : bgpSpeakers) {
            log.debug("Start to set up BGP paths for BGP speaker: {}", (Object)bgpSpeaker);
            this.buildSpeakerIntents(bgpSpeaker, encap).forEach(i -> {
                PointToPointIntent intent = (PointToPointIntent)existingIntents.remove(i.key());
                if (intent == null || !IntentUtils.intentsAreEqual((Intent)i, (Intent)intent)) {
                    this.peerIntents.put(i.key(), (PointToPointIntent)i);
                    this.intentSynchronizer.submit((Intent)i);
                }
            });
        }
        existingIntents.values().forEach(i -> {
            this.peerIntents.remove(i.key());
            this.intentSynchronizer.withdraw((Intent)i);
        });
    }

    private Collection<PointToPointIntent> buildSpeakerIntents(BgpConfig.BgpSpeakerConfig speaker, EncapsulationType encap) {
        ArrayList<PointToPointIntent> intents = new ArrayList<PointToPointIntent>();
        VlanId bgpSpeakerVlanId = speaker.vlan();
        for (IpAddress peerAddress : speaker.peers()) {
            Interface peeringInterface = this.interfaceService.getMatchingInterface(peerAddress);
            if (peeringInterface == null) {
                log.debug("No peering interface found for peer {} on speaker {}", (Object)peerAddress, (Object)speaker);
                continue;
            }
            IpAddress bgpSpeakerAddress = null;
            for (InterfaceIpAddress address : peeringInterface.ipAddressesList()) {
                if (!address.subnetAddress().contains(peerAddress)) continue;
                bgpSpeakerAddress = address.ipAddress();
                break;
            }
            Preconditions.checkNotNull(bgpSpeakerAddress);
            VlanId peerVlanId = peeringInterface.vlan();
            intents.addAll(this.buildIntents(speaker.connectPoint(), bgpSpeakerVlanId, bgpSpeakerAddress, peeringInterface.connectPoint(), peerVlanId, peerAddress, encap));
        }
        return intents;
    }

    private Collection<PointToPointIntent> buildIntents(ConnectPoint portOne, VlanId vlanOne, IpAddress ipOne, ConnectPoint portTwo, VlanId vlanTwo, IpAddress ipTwo, EncapsulationType encap) {
        byte icmpProtocol;
        byte tcpProtocol;
        ArrayList<PointToPointIntent> intents = new ArrayList<PointToPointIntent>();
        TrafficTreatment.Builder treatmentToPeer = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder treatmentToSpeaker = DefaultTrafficTreatment.builder();
        if (ipOne.isIp4()) {
            tcpProtocol = 6;
            icmpProtocol = 1;
        } else {
            tcpProtocol = 6;
            icmpProtocol = 58;
        }
        treatmentToPeer = this.applyVlanTreatment(vlanOne, vlanTwo, treatmentToPeer);
        TrafficSelector selector = this.buildSelector(tcpProtocol, vlanOne, ipOne, ipTwo, null, (short)179);
        Key key = this.buildKey(ipOne, ipTwo, SUFFIX_DST);
        PointToPointIntent.Builder intentBuilder = PointToPointIntent.builder().appId(this.appId).key(key).filteredIngressPoint(new FilteredConnectPoint(portOne)).filteredEgressPoint(new FilteredConnectPoint(portTwo)).selector(selector).treatment(treatmentToPeer.build()).priority(1000);
        PeerConnectivityManager.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        intents.add(intentBuilder.build());
        selector = this.buildSelector(tcpProtocol, vlanOne, ipOne, ipTwo, (short)179, null);
        key = this.buildKey(ipOne, ipTwo, SUFFIX_SRC);
        intentBuilder = PointToPointIntent.builder().appId(this.appId).key(key).filteredIngressPoint(new FilteredConnectPoint(portOne)).filteredEgressPoint(new FilteredConnectPoint(portTwo)).selector(selector).treatment(treatmentToPeer.build()).priority(1000);
        PeerConnectivityManager.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        intents.add(intentBuilder.build());
        selector = this.buildSelector(icmpProtocol, vlanOne, ipOne, ipTwo, null, null);
        key = this.buildKey(ipOne, ipTwo, SUFFIX_ICMP);
        intentBuilder = PointToPointIntent.builder().appId(this.appId).key(key).filteredIngressPoint(new FilteredConnectPoint(portOne)).filteredEgressPoint(new FilteredConnectPoint(portTwo)).selector(selector).treatment(treatmentToPeer.build()).priority(1000);
        PeerConnectivityManager.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        intents.add(intentBuilder.build());
        treatmentToSpeaker = this.applyVlanTreatment(vlanTwo, vlanOne, treatmentToSpeaker);
        selector = this.buildSelector(tcpProtocol, vlanTwo, ipTwo, ipOne, null, (short)179);
        key = this.buildKey(ipTwo, ipOne, SUFFIX_DST);
        intentBuilder = PointToPointIntent.builder().appId(this.appId).key(key).filteredIngressPoint(new FilteredConnectPoint(portTwo)).filteredEgressPoint(new FilteredConnectPoint(portOne)).selector(selector).treatment(treatmentToSpeaker.build()).priority(1000);
        PeerConnectivityManager.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        intents.add(intentBuilder.build());
        selector = this.buildSelector(tcpProtocol, vlanTwo, ipTwo, ipOne, (short)179, null);
        key = this.buildKey(ipTwo, ipOne, SUFFIX_SRC);
        intentBuilder = PointToPointIntent.builder().appId(this.appId).key(key).filteredIngressPoint(new FilteredConnectPoint(portTwo)).filteredEgressPoint(new FilteredConnectPoint(portOne)).selector(selector).treatment(treatmentToSpeaker.build()).priority(1000);
        PeerConnectivityManager.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        intents.add(intentBuilder.build());
        selector = this.buildSelector(icmpProtocol, vlanTwo, ipTwo, ipOne, null, null);
        key = this.buildKey(ipTwo, ipOne, SUFFIX_ICMP);
        intentBuilder = PointToPointIntent.builder().appId(this.appId).key(key).filteredIngressPoint(new FilteredConnectPoint(portTwo)).filteredEgressPoint(new FilteredConnectPoint(portOne)).selector(selector).treatment(treatmentToSpeaker.build()).priority(1000);
        PeerConnectivityManager.encap((ConnectivityIntent.Builder)intentBuilder, encap);
        intents.add(intentBuilder.build());
        return intents;
    }

    private TrafficSelector buildSelector(byte ipProto, VlanId ingressVlanId, IpAddress srcIp, IpAddress dstIp, Short srcTcpPort, Short dstTcpPort) {
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder().matchIPProtocol(ipProto);
        if (!ingressVlanId.equals((Object)VlanId.NONE)) {
            builder.matchVlanId(ingressVlanId);
        }
        if (dstIp.isIp4()) {
            builder.matchEthType(Ethernet.TYPE_IPV4).matchIPSrc(IpPrefix.valueOf((IpAddress)srcIp, (int)32)).matchIPDst(IpPrefix.valueOf((IpAddress)dstIp, (int)32));
        } else {
            builder.matchEthType(Ethernet.TYPE_IPV6).matchIPv6Src(IpPrefix.valueOf((IpAddress)srcIp, (int)128)).matchIPv6Dst(IpPrefix.valueOf((IpAddress)dstIp, (int)128));
        }
        if (srcTcpPort != null) {
            builder.matchTcpSrc(TpPort.tpPort((int)srcTcpPort.shortValue()));
        }
        if (dstTcpPort != null) {
            builder.matchTcpDst(TpPort.tpPort((int)dstTcpPort.shortValue()));
        }
        return builder.build();
    }

    private TrafficTreatment.Builder applyVlanTreatment(VlanId vlanOne, VlanId vlanTwo, TrafficTreatment.Builder treatment) {
        if (!vlanOne.equals((Object)vlanTwo)) {
            if (vlanTwo.equals((Object)VlanId.NONE)) {
                treatment.popVlan();
            } else {
                if (vlanOne.equals((Object)VlanId.NONE)) {
                    treatment.pushVlan();
                }
                treatment.setVlanId(vlanTwo);
            }
        }
        return treatment;
    }

    private Key buildKey(IpAddress srcIp, IpAddress dstIp, String suffix) {
        String keyString = srcIp.toString() + "-" + dstIp.toString() + "-" + suffix;
        return Key.of((String)keyString, (ApplicationId)this.appId);
    }

    private static void encap(ConnectivityIntent.Builder builder, EncapsulationType encap) {
        if (!encap.equals((Object)EncapsulationType.NONE)) {
            builder.constraints((List)ImmutableList.of((Object)new EncapsulationConstraint(encap)));
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: 
                case INTERFACE_UPDATED: 
                case INTERFACE_REMOVED: {
                    PeerConnectivityManager.this.setUpConnectivity();
                    break;
                }
            }
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_REGISTERED: {
                    break;
                }
                case CONFIG_UNREGISTERED: {
                    break;
                }
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: 
                case CONFIG_REMOVED: {
                    if (event.configClass() != RoutingService.CONFIG_CLASS && event.configClass() != SdnIpConfig.class) break;
                    PeerConnectivityManager.this.setUpConnectivity();
                    break;
                }
            }
        }
    }
}

