/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpPrefixAttrIgpFlags
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpPrefixAttrIgpFlags.class);
    public static final int ATTR_PREFIX_FLAGBIT = 1152;
    public static final int ATTR_PREFIX_FLAG_LEN = 1;
    public static final byte FIRST_BIT = -128;
    public static final byte SECOND_BIT = 64;
    public static final byte THIRD_BIT = 32;
    public static final byte FOURTH_BIT = 1;
    private final boolean bisisUpDownBit;
    private final boolean bOspfNoUnicastBit;
    private final boolean bOspfLclAddrBit;
    private final boolean bOspfNSSABit;

    public BgpPrefixAttrIgpFlags(boolean bisisUpDownBit, boolean bOspfNoUnicastBit, boolean bOspfLclAddrBit, boolean bOspfNssaBit) {
        this.bisisUpDownBit = bisisUpDownBit;
        this.bOspfNoUnicastBit = bOspfNoUnicastBit;
        this.bOspfLclAddrBit = bOspfLclAddrBit;
        this.bOspfNSSABit = bOspfNssaBit;
    }

    public static BgpPrefixAttrIgpFlags of(boolean bisisUpDownBit, boolean bOspfNoUnicastBit, boolean bOspfLclAddrBit, boolean bOspfNssaBit) {
        return new BgpPrefixAttrIgpFlags(bisisUpDownBit, bOspfNoUnicastBit, bOspfLclAddrBit, bOspfNssaBit);
    }

    public static BgpPrefixAttrIgpFlags read(ChannelBuffer cb) throws BgpParseException {
        byte nodeFlagBits;
        boolean bisisUpDownBit = false;
        boolean bOspfNoUnicastBit = false;
        boolean bOspfLclAddrBit = false;
        boolean bOspfNssaBit = false;
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 1 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        bisisUpDownBit = ((nodeFlagBits = cb.readByte()) & 0xFFFFFF80) == -128;
        bOspfNoUnicastBit = (nodeFlagBits & 0x40) == 64;
        bOspfLclAddrBit = (nodeFlagBits & 0x20) == 32;
        bOspfNssaBit = (nodeFlagBits & 1) == 1;
        return BgpPrefixAttrIgpFlags.of(bisisUpDownBit, bOspfNoUnicastBit, bOspfLclAddrBit, bOspfNssaBit);
    }

    public boolean isisUpDownBit() {
        return this.bisisUpDownBit;
    }

    public boolean ospfNoUnicastBit() {
        return this.bOspfNoUnicastBit;
    }

    public boolean ospfLclAddrBit() {
        return this.bOspfLclAddrBit;
    }

    public boolean ospfNssaBit() {
        return this.bOspfNSSABit;
    }

    @Override
    public short getType() {
        return 1152;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.bisisUpDownBit, this.bOspfNoUnicastBit, this.bOspfLclAddrBit, this.bOspfNSSABit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpPrefixAttrIgpFlags) {
            BgpPrefixAttrIgpFlags other = (BgpPrefixAttrIgpFlags)obj;
            return Objects.equals(this.bisisUpDownBit, other.bisisUpDownBit) && Objects.equals(this.bOspfNoUnicastBit, other.bOspfNoUnicastBit) && Objects.equals(this.bOspfLclAddrBit, other.bOspfLclAddrBit) && Objects.equals(this.bOspfNSSABit, other.bOspfNSSABit);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("bisisUpDownBit", this.bisisUpDownBit).add("bOspfNoUnicastBit", this.bOspfNoUnicastBit).add("bOspfLclAddrBit", this.bOspfLclAddrBit).add("bOspfNSSABit", this.bOspfNSSABit).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

