/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpLinkAttrOpaqLnkAttrib
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpLinkAttrOpaqLnkAttrib.class);
    public static final int ATTRNODE_OPAQUELNKATTRIB = 1097;
    private final byte[] opaqueLinkAttribute;

    private BgpLinkAttrOpaqLnkAttrib(byte[] opaqueLinkAttribute) {
        this.opaqueLinkAttribute = Arrays.copyOf(opaqueLinkAttribute, opaqueLinkAttribute.length);
    }

    public static BgpLinkAttrOpaqLnkAttrib of(byte[] opaqueLinkAttribute) {
        return new BgpLinkAttrOpaqLnkAttrib(opaqueLinkAttribute);
    }

    public static BgpLinkAttrOpaqLnkAttrib read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte[] opaqueLinkAttribute = new byte[lsAttrLength];
        cb.readBytes(opaqueLinkAttribute);
        return BgpLinkAttrOpaqLnkAttrib.of(opaqueLinkAttribute);
    }

    public byte[] attrOpaqueLnk() {
        return this.opaqueLinkAttribute;
    }

    @Override
    public short getType() {
        return 1097;
    }

    public int hashCode() {
        return Arrays.hashCode(this.opaqueLinkAttribute);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrOpaqLnkAttrib) {
            BgpLinkAttrOpaqLnkAttrib other = (BgpLinkAttrOpaqLnkAttrib)obj;
            return Arrays.equals(this.opaqueLinkAttribute, other.opaqueLinkAttribute);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("opaqueLinkAttribute", (Object)this.opaqueLinkAttribute).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

