/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpAttrOpaqueNode
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpAttrOpaqueNode.class);
    public static final int ATTRNODE_OPAQUEDATA = 1025;
    private byte[] opaqueNodeAttribute;

    public BgpAttrOpaqueNode(byte[] opaqueNodeAttribute) {
        this.opaqueNodeAttribute = Arrays.copyOf(opaqueNodeAttribute, opaqueNodeAttribute.length);
    }

    public static BgpAttrOpaqueNode of(byte[] opaqueNodeAttribute) {
        return new BgpAttrOpaqueNode(opaqueNodeAttribute);
    }

    public static BgpAttrOpaqueNode read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte[] opaqueNodeAttribute = new byte[lsAttrLength];
        cb.readBytes(opaqueNodeAttribute);
        return BgpAttrOpaqueNode.of(opaqueNodeAttribute);
    }

    public byte[] attrOpaqueNode() {
        return this.opaqueNodeAttribute;
    }

    @Override
    public short getType() {
        return 1025;
    }

    public int hashCode() {
        return Arrays.hashCode(this.opaqueNodeAttribute);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpAttrOpaqueNode) {
            BgpAttrOpaqueNode other = (BgpAttrOpaqueNode)obj;
            return Arrays.equals(this.opaqueNodeAttribute, other.opaqueNodeAttribute);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("opaqueNodeAttribute", (Object)this.opaqueNodeAttribute).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

