/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpAttrNodeMultiTopologyId
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpAttrNodeMultiTopologyId.class);
    public static final int ATTRNODE_MULTITOPOLOGY = 263;
    private List<Short> multiTopologyId = new ArrayList<Short>();

    public BgpAttrNodeMultiTopologyId(List<Short> multiTopologyId) {
        this.multiTopologyId = multiTopologyId;
    }

    public static BgpAttrNodeMultiTopologyId of(ArrayList<Short> multiTopologyId) {
        return new BgpAttrNodeMultiTopologyId(multiTopologyId);
    }

    public static BgpAttrNodeMultiTopologyId read(ChannelBuffer cb) throws BgpParseException {
        ArrayList<Short> multiTopologyId = new ArrayList<Short>();
        short lsAttrLength = cb.readShort();
        int len = lsAttrLength / 2;
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        for (int i = 0; i < len; ++i) {
            short tempMultiTopologyId = cb.readShort();
            multiTopologyId.add(new Short(tempMultiTopologyId));
        }
        return new BgpAttrNodeMultiTopologyId(multiTopologyId);
    }

    public List<Short> attrMultiTopologyId() {
        return this.multiTopologyId;
    }

    @Override
    public short getType() {
        return 263;
    }

    public int hashCode() {
        return Objects.hash(this.multiTopologyId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpAttrNodeMultiTopologyId) {
            BgpAttrNodeMultiTopologyId other = (BgpAttrNodeMultiTopologyId)obj;
            return Objects.equals(this.multiTopologyId, other.multiTopologyId);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("multiTopologyId", this.multiTopologyId).toString();
    }

    @Override
    public int compareTo(Object o) {
        int countObjSubTlv;
        if (this.equals(o)) {
            return 0;
        }
        int countOtherSubTlv = ((BgpAttrNodeMultiTopologyId)o).multiTopologyId.size();
        if (countOtherSubTlv != (countObjSubTlv = this.multiTopologyId.size())) {
            if (countOtherSubTlv > countObjSubTlv) {
                return 1;
            }
            return -1;
        }
        ListIterator<Short> listIterator = this.multiTopologyId.listIterator();
        ListIterator<Short> listIteratorOther = ((BgpAttrNodeMultiTopologyId)o).multiTopologyId.listIterator();
        while (listIterator.hasNext()) {
            short id = listIterator.next();
            short id1 = listIteratorOther.next();
            if (Short.valueOf(id).compareTo(id1) == 0) continue;
            return Short.valueOf(id).compareTo(id1);
        }
        return 0;
    }
}

