/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpAttrNodeFlagBitTlv
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpAttrNodeFlagBitTlv.class);
    public static final int ATTRNODE_FLAGBIT = 1024;
    private final boolean bOverloadBit;
    private final boolean bAttachedBit;
    private final boolean bExternalBit;
    private final boolean bAbrBit;
    public static final byte FIRST_BIT = -128;
    public static final byte SECOND_BIT = 64;
    public static final byte THIRD_BIT = 32;
    public static final byte FOURTH_BIT = 1;

    public BgpAttrNodeFlagBitTlv(boolean bOverloadBit, boolean bAttachedBit, boolean bExternalBit, boolean bAbrBit) {
        this.bOverloadBit = bOverloadBit;
        this.bAttachedBit = bAttachedBit;
        this.bExternalBit = bExternalBit;
        this.bAbrBit = bAbrBit;
    }

    public static BgpAttrNodeFlagBitTlv of(boolean bOverloadBit, boolean bAttachedBit, boolean bExternalBit, boolean bAbrBit) {
        return new BgpAttrNodeFlagBitTlv(bOverloadBit, bAttachedBit, bExternalBit, bAbrBit);
    }

    public static BgpAttrNodeFlagBitTlv read(ChannelBuffer cb) throws BgpParseException {
        byte nodeFlagBits;
        boolean bOverloadBit = false;
        boolean bAttachedBit = false;
        boolean bExternalBit = false;
        boolean bAbrBit = false;
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 1 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        bOverloadBit = ((nodeFlagBits = cb.readByte()) & 0xFFFFFF80) == -128;
        bAttachedBit = (nodeFlagBits & 0x40) == 64;
        bExternalBit = (nodeFlagBits & 0x20) == 32;
        bAbrBit = (nodeFlagBits & 1) == 1;
        return BgpAttrNodeFlagBitTlv.of(bOverloadBit, bAttachedBit, bExternalBit, bAbrBit);
    }

    public boolean overLoadBit() {
        return this.bOverloadBit;
    }

    public boolean attachedBit() {
        return this.bAttachedBit;
    }

    public boolean externalBit() {
        return this.bExternalBit;
    }

    public boolean abrBit() {
        return this.bAbrBit;
    }

    @Override
    public short getType() {
        return 1024;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.bOverloadBit, this.bAttachedBit, this.bExternalBit, this.bAbrBit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpAttrNodeFlagBitTlv) {
            BgpAttrNodeFlagBitTlv other = (BgpAttrNodeFlagBitTlv)obj;
            return Objects.equals(this.bOverloadBit, other.bOverloadBit) && Objects.equals(this.bAttachedBit, other.bAttachedBit) && Objects.equals(this.bExternalBit, other.bExternalBit) && Objects.equals(this.bAbrBit, other.bAbrBit);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("bOverloadBit", this.bOverloadBit).add("bAttachedBit", this.bAttachedBit).add("bExternalBit", this.bExternalBit).add("bAbrBit", this.bAbrBit).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

