/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpdCapabilityTlv
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(RpdCapabilityTlv.class);
    public static final byte TYPE = -127;
    public static final byte LENGTH = 4;
    private short afi = 1;
    private byte sAfi = (byte)-123;
    private final byte sendReceive;

    public RpdCapabilityTlv(byte sendReceive) {
        this.sendReceive = sendReceive;
    }

    public static RpdCapabilityTlv of(byte sendReceive) {
        return new RpdCapabilityTlv(sendReceive);
    }

    public byte sendReceive() {
        return this.sendReceive;
    }

    public short getAfi() {
        return this.afi;
    }

    public byte getSafi() {
        return this.sAfi;
    }

    @Override
    public short getType() {
        return -127;
    }

    public int hashCode() {
        return Objects.hash(this.sendReceive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RpdCapabilityTlv) {
            RpdCapabilityTlv other = (RpdCapabilityTlv)obj;
            return Objects.equals(this.sendReceive, other.sendReceive);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(-127);
        cb.writeByte(4);
        cb.writeShort((int)this.afi);
        cb.writeByte((int)this.sAfi);
        cb.writeByte((int)this.sendReceive);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static RpdCapabilityTlv read(ChannelBuffer cb) {
        short afi = cb.readShort();
        byte sAfi = cb.readByte();
        return RpdCapabilityTlv.of(cb.readByte());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -127).add("Length", 4).add("afi", (int)this.afi).add("safi", (int)this.sAfi).add("sendReceive", (int)this.sendReceive).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

