/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class IPv6AddressTlv
implements BgpValueType {
    private static final int LENGTH = 16;
    private final Ip6Address address;
    private short type;

    public IPv6AddressTlv(Ip6Address address, short type) {
        this.address = (Ip6Address)Preconditions.checkNotNull((Object)address);
        this.type = type;
    }

    public Ip6Address address() {
        return this.address;
    }

    @Override
    public short getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPv6AddressTlv) {
            IPv6AddressTlv other = (IPv6AddressTlv)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.type, other.type);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort((int)this.type);
        cb.writeShort(16);
        cb.writeBytes(this.address.toOctets());
        return cb.writerIndex() - iLenStartIndex;
    }

    public static IPv6AddressTlv read(ChannelBuffer cb, short type) throws BgpParseException {
        InetAddress ipAddress = Validation.toInetAddress(16, cb);
        if (ipAddress.isMulticastAddress()) {
            throw new BgpParseException(3, 0, null);
        }
        Ip6Address address = Ip6Address.valueOf((InetAddress)ipAddress);
        return IPv6AddressTlv.of(address, type);
    }

    public static IPv6AddressTlv of(Ip6Address address, short type) {
        return new IPv6AddressTlv(address, type);
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.address.compareTo((IpAddress)((IPv6AddressTlv)o).address);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", (int)this.type).add("LENGTH", 16).add("address", (Object)this.address).toString();
    }
}

