/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpFsOperatorValue;
import org.onosproject.bgpio.types.BgpValueType;

public class BgpFsSourcePortNum
implements BgpValueType {
    public static final byte FLOW_SPEC_TYPE = 6;
    private List<BgpFsOperatorValue> operatorValue;

    public BgpFsSourcePortNum(List<BgpFsOperatorValue> operatorValue) {
        this.operatorValue = operatorValue;
    }

    @Override
    public short getType() {
        return 6;
    }

    public int hashCode() {
        return Objects.hash(this.operatorValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFsSourcePortNum) {
            BgpFsSourcePortNum other = (BgpFsSourcePortNum)obj;
            return this.operatorValue.equals(other.operatorValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(6);
        for (BgpFsOperatorValue fsOperVal : this.operatorValue) {
            cb.writeByte((int)fsOperVal.option());
            cb.writeBytes(fsOperVal.value());
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    public static BgpFsSourcePortNum read(ChannelBuffer cb) throws BgpParseException {
        byte option;
        LinkedList<BgpFsOperatorValue> operatorValue = new LinkedList<BgpFsOperatorValue>();
        do {
            short port;
            int len;
            if (1 << (len = ((option = cb.readByte()) & 0x30) >> 4) == 1) {
                port = cb.readByte();
                operatorValue.add(new BgpFsOperatorValue(option, new byte[]{(byte)port}));
                continue;
            }
            port = cb.readShort();
            operatorValue.add(new BgpFsOperatorValue(option, new byte[]{(byte)(port >> 8), (byte)port}));
        } while ((option & 0xFFFFFF80) == 0);
        return new BgpFsSourcePortNum(operatorValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("FLOW_SPEC_TYPE", 6).add("operatorValue", this.operatorValue).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

