/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class BgpFsDestinationPrefix
implements BgpValueType {
    public static final byte FLOW_SPEC_TYPE = 1;
    private byte length;
    private IpPrefix ipPrefix;
    public static final int BYTE_IN_BITS = 8;

    public BgpFsDestinationPrefix(byte length, IpPrefix ipPrefix) {
        this.ipPrefix = (IpPrefix)Preconditions.checkNotNull((Object)ipPrefix);
        this.length = length;
    }

    public IpPrefix ipPrefix() {
        return this.ipPrefix;
    }

    @Override
    public short getType() {
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.ipPrefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFsDestinationPrefix) {
            BgpFsDestinationPrefix other = (BgpFsDestinationPrefix)obj;
            return Objects.equals(this.ipPrefix, other.ipPrefix);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(1);
        cb.writeByte((int)this.length);
        cb.writeInt(this.ipPrefix.getIp4Prefix().address().toInt());
        return cb.writerIndex() - iLenStartIndex;
    }

    public static BgpFsDestinationPrefix read(ChannelBuffer cb) throws BgpParseException {
        byte length = cb.readByte();
        if (length == 0) {
            byte[] prefix = new byte[]{0};
            IpPrefix ipPrefix = Validation.bytesToPrefix(prefix, length);
            return new BgpFsDestinationPrefix((byte)ipPrefix.prefixLength(), ipPrefix);
        }
        int len = length / 8;
        int reminder = length % 8;
        if (reminder > 0) {
            ++len;
        }
        if (cb.readableBytes() < len) {
            Validation.validateLen((byte)3, (byte)1, cb.readableBytes());
        }
        byte[] prefix = new byte[len];
        cb.readBytes(prefix, 0, len);
        IpPrefix ipPrefix = Validation.bytesToPrefix(prefix, length);
        return new BgpFsDestinationPrefix((byte)ipPrefix.prefixLength(), ipPrefix);
    }

    public static BgpFsDestinationPrefix of(IpPrefix ipPrefix, byte length) {
        return new BgpFsDestinationPrefix(length, ipPrefix);
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o instanceof BgpFsDestinationPrefix) {
            BgpFsDestinationPrefix that = (BgpFsDestinationPrefix)o;
            if (this.ipPrefix().prefixLength() == that.ipPrefix().prefixLength()) {
                ByteBuffer value1 = ByteBuffer.wrap(this.ipPrefix.address().toOctets());
                ByteBuffer value2 = ByteBuffer.wrap(that.ipPrefix.address().toOctets());
                return value1.compareTo(value2);
            }
            if (this.ipPrefix().prefixLength() > that.ipPrefix().prefixLength()) {
                return 1;
            }
            if (this.ipPrefix().prefixLength() < that.ipPrefix().prefixLength()) {
                return -1;
            }
        }
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("FLOW_SPEC_TYPE", 1).add("length", (int)this.length).add("ipPrefix", (Object)this.ipPrefix).toString();
    }
}

