/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;

public class BgpFsActionTrafficAction
implements BgpValueType {
    public static final short TYPE = -32761;
    private byte[] bitMask;
    public static final byte BIT_MASK_LEN = 6;

    public BgpFsActionTrafficAction(byte[] bitMask) {
        this.bitMask = Arrays.copyOf(bitMask, bitMask.length);
    }

    @Override
    public short getType() {
        return -32761;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bitMask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFsActionTrafficAction) {
            BgpFsActionTrafficAction other = (BgpFsActionTrafficAction)obj;
            return Arrays.equals(this.bitMask, other.bitMask);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort(-32761);
        cb.writeBytes(this.bitMask);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static BgpFsActionTrafficAction read(ChannelBuffer cb) throws BgpParseException {
        byte[] bitMask = cb.readBytes(6).array();
        return new BgpFsActionTrafficAction(bitMask);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TYPE", -32761).add("bitMask", (Object)this.bitMask).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

