/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onosproject.bgpio.types.BgpEvpnLabel;
import org.onosproject.bgpio.types.RouteTarget;

public class BgpEvpnPrefix {
    private Ip4Address nextHop;
    private RouteTarget rt;
    BgpEvpnLabel label;

    public BgpEvpnPrefix(Ip4Address nextHop, RouteTarget rt, BgpEvpnLabel label) {
        this.nextHop = nextHop;
        this.rt = rt;
        this.label = label;
    }

    public BgpEvpnPrefix(Ip4Address nextHop, BgpEvpnLabel label) {
        this.nextHop = nextHop;
        this.label = label;
    }

    public Ip4Address getNextHop() {
        return this.nextHop;
    }

    public RouteTarget getRouteTarget() {
        return this.rt;
    }

    public BgpEvpnLabel getLabel() {
        return this.label;
    }

    public void setNetHop(Ip4Address nextHop) {
        this.nextHop = nextHop;
    }

    public void setRouteTarget(RouteTarget rt) {
        this.rt = rt;
    }

    public void setLabel(BgpEvpnLabel label) {
        this.label = label;
    }

    public int hashCode() {
        return Objects.hash(this.nextHop, this.rt, this.label);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BgpEvpnPrefix)) {
            return false;
        }
        BgpEvpnPrefix that = (BgpEvpnPrefix)other;
        return Objects.equals(this.nextHop, that.nextHop) && Objects.equals(this.rt, that.rt) && Objects.equals(this.label, that.label);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("next hop", (Object)this.nextHop).add("route target", (Object)this.rt).add("label", (Object)this.label).toString();
    }
}

