/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.ver4;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.ver4.BgpKeepaliveMsgVer4;
import org.onosproject.bgpio.protocol.ver4.BgpNotificationMsgVer4;
import org.onosproject.bgpio.protocol.ver4.BgpOpenMsgVer4;
import org.onosproject.bgpio.protocol.ver4.BgpUpdateMsgVer4;
import org.onosproject.bgpio.types.BgpHeader;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BgpMessageVer4 {
    private static final Logger log = LoggerFactory.getLogger(BgpFactories.class);
    static final byte OPEN_MSG_TYPE = 1;
    static final byte KEEPALIVE_MSG_TYPE = 4;
    static final byte UPDATE_MSG_TYPE = 2;
    static final byte NOTIFICATION_MSG_TYPE = 3;
    static final int MINIMUM_COMMON_HEADER_LENGTH = 19;
    static final int HEADER_AND_MSG_LEN = 18;
    static final int MAXIMUM_PACKET_LENGTH = 4096;
    public static final Reader READER = new Reader();

    static class Reader
    implements BgpMessageReader<BgpMessage> {
        Reader() {
        }

        @Override
        public BgpMessage readFrom(ChannelBuffer cb, BgpHeader bgpHeader) throws BgpParseException {
            if (cb.readableBytes() < 19) {
                log.error("Packet should have minimum length.");
                Validation.validateLen((byte)1, (byte)2, cb.readableBytes());
            }
            if (cb.readableBytes() > 4096) {
                log.error("Packet length should not exceed {}.", (Object)4096);
                Validation.validateLen((byte)1, (byte)2, cb.readableBytes());
            }
            try {
                byte[] marker = new byte[16];
                cb.readBytes(marker, 0, 16);
                bgpHeader.setMarker(marker);
                for (int i = 0; i < 16; ++i) {
                    if (marker[i] == -1) continue;
                    throw new BgpParseException(1, 1, null);
                }
                short length = cb.readShort();
                if (length > cb.readableBytes() + 18) {
                    Validation.validateLen((byte)1, (byte)2, length);
                }
                bgpHeader.setLength(length);
                byte type = cb.readByte();
                bgpHeader.setType(type);
                log.debug("Reading update message of type " + type);
                int len = length - 19;
                switch (type) {
                    case 1: {
                        log.debug("OPEN MESSAGE is received");
                        return BgpOpenMsgVer4.READER.readFrom(cb.readBytes(len), bgpHeader);
                    }
                    case 4: {
                        log.debug("KEEPALIVE MESSAGE is received");
                        return BgpKeepaliveMsgVer4.READER.readFrom(cb.readBytes(len), bgpHeader);
                    }
                    case 2: {
                        log.debug("UPDATE MESSAGE is received");
                        return BgpUpdateMsgVer4.READER.readFrom(cb.readBytes(len), bgpHeader);
                    }
                    case 3: {
                        log.debug("NOTIFICATION MESSAGE is received");
                        return BgpNotificationMsgVer4.READER.readFrom(cb.readBytes(len), bgpHeader);
                    }
                }
                Validation.validateType((byte)1, (byte)3, type);
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                throw new BgpParseException(1, 2, null);
            }
        }
    }
}

