/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactory;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.protocol.ver4.BgpFactoryVer4;
import org.onosproject.bgpio.types.BgpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpFactories {
    private static final Logger log = LoggerFactory.getLogger(BgpFactories.class);
    private static final GenericReader GENERIC_READER = new GenericReader();

    private BgpFactories() {
    }

    public static BgpFactory getFactory(BgpVersion version) {
        switch (version) {
            case BGP_4: {
                return BgpFactoryVer4.INSTANCE;
            }
        }
        throw new IllegalArgumentException("[BgpFactory:]Unknown version: " + (Object)((Object)version));
    }

    public static BgpMessageReader<BgpMessage> getGenericReader() {
        return GENERIC_READER;
    }

    private static class GenericReader
    implements BgpMessageReader<BgpMessage> {
        private GenericReader() {
        }

        @Override
        public BgpMessage readFrom(ChannelBuffer bb, BgpHeader bgpHeader) throws BgpParseException {
            if (!bb.readable()) {
                log.error("Empty message received");
                throw new BgpParseException("Empty message received");
            }
            BgpFactoryVer4 factory = BgpFactoryVer4.INSTANCE;
            return factory.getReader().readFrom(bb, bgpHeader);
        }
    }
}

