/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpAttrRouterIdV4
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpAttrRouterIdV4.class);
    private final short sType;
    private final Ip4Address ip4RouterId;

    private BgpAttrRouterIdV4(Ip4Address ip4RouterId, short sType) {
        this.ip4RouterId = ip4RouterId;
        this.sType = sType;
    }

    public static BgpAttrRouterIdV4 of(Ip4Address ip4RouterId, short sType) {
        return new BgpAttrRouterIdV4(ip4RouterId, sType);
    }

    public static BgpAttrRouterIdV4 read(ChannelBuffer cb, short sType) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 4 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte[] ipBytes = new byte[lsAttrLength];
        cb.readBytes(ipBytes, 0, (int)lsAttrLength);
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        return BgpAttrRouterIdV4.of(ip4RouterId, sType);
    }

    public Ip4Address attrRouterId() {
        return this.ip4RouterId;
    }

    @Override
    public short getType() {
        return this.sType;
    }

    public int hashCode() {
        return Objects.hash(this.ip4RouterId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpAttrRouterIdV4) {
            BgpAttrRouterIdV4 other = (BgpAttrRouterIdV4)obj;
            return Objects.equals(this.ip4RouterId, other.ip4RouterId);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ip4RouterId", (Object)this.ip4RouterId).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

