/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpAttrNodeIsIsAreaId
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(BgpAttrNodeIsIsAreaId.class);
    public static final int ATTRNODE_ISISAREAID = 1027;
    private byte[] isisAreaId;

    public BgpAttrNodeIsIsAreaId(byte[] isisAreaId) {
        this.isisAreaId = Arrays.copyOf(isisAreaId, isisAreaId.length);
    }

    public static BgpAttrNodeIsIsAreaId of(byte[] isisAreaId) {
        return new BgpAttrNodeIsIsAreaId(isisAreaId);
    }

    public static BgpAttrNodeIsIsAreaId read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte[] isisAreaId = new byte[lsAttrLength];
        cb.readBytes(isisAreaId);
        return BgpAttrNodeIsIsAreaId.of(isisAreaId);
    }

    public byte[] attrNodeIsIsAreaId() {
        return this.isisAreaId;
    }

    @Override
    public short getType() {
        return 1027;
    }

    public int hashCode() {
        return Arrays.hashCode(this.isisAreaId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpAttrNodeIsIsAreaId) {
            BgpAttrNodeIsIsAreaId other = (BgpAttrNodeIsIsAreaId)obj;
            return Arrays.equals(this.isisAreaId, other.isisAreaId);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("isisAreaId", (Object)this.isisAreaId).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

