/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.attr.WideCommunity;

public class WideCommunityTarget
implements BgpValueType {
    public static final byte TYPE = 1;
    private List<BgpValueType> targetTlv;

    public WideCommunityTarget(List<BgpValueType> targetTlv) {
        this.targetTlv = targetTlv;
    }

    public static WideCommunityTarget of(List<BgpValueType> targetTlv) {
        return new WideCommunityTarget(targetTlv);
    }

    public List<BgpValueType> targetTlv() {
        return this.targetTlv;
    }

    public void setTargetTlv(List<BgpValueType> targetTlv) {
        this.targetTlv = targetTlv;
    }

    public int hashCode() {
        return Objects.hash(this.targetTlv);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WideCommunityTarget) {
            WideCommunityTarget other = (WideCommunityTarget)obj;
            return Objects.equals(this.targetTlv, other.targetTlv);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        WideCommunity.encodeWideCommunityTlv(c, this.targetTlv());
        return c.writerIndex() - iLenStartIndex;
    }

    public static WideCommunityTarget read(ChannelBuffer c) throws BgpParseException {
        return new WideCommunityTarget(WideCommunity.decodeWideCommunityTlv(c));
    }

    @Override
    public short getType() {
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1).add("targetTlv", this.targetTlv).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

