/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.IpAddress;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class WideCommunityIpV4Neighbour
implements BgpValueType {
    public static final byte TYPE = 8;
    private List<IpV4Neighbour> ipv4Neighbour = new ArrayList<IpV4Neighbour>();
    public static final byte IPV4_NEIGHBOUR_SIZE = 8;

    public void add(IpAddress localSpeaker, IpAddress remoteSpeaker) {
        this.ipv4Neighbour.add(new IpV4Neighbour(localSpeaker, remoteSpeaker));
    }

    public void remove(IpAddress localSpeaker, IpAddress remoteSpeaker) {
        this.ipv4Neighbour.remove(new IpV4Neighbour(localSpeaker, remoteSpeaker));
    }

    public int hashCode() {
        return Objects.hash(this.ipv4Neighbour);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WideCommunityIpV4Neighbour) {
            WideCommunityIpV4Neighbour other = (WideCommunityIpV4Neighbour)obj;
            return Objects.equals(this.ipv4Neighbour, other.ipv4Neighbour);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        Iterator<IpV4Neighbour> listIterator = this.ipv4Neighbour.iterator();
        c.writeByte(8);
        int iLengthIndex = c.writerIndex();
        c.writeShort(0);
        while (listIterator.hasNext()) {
            IpV4Neighbour speaker = listIterator.next();
            if (!(speaker instanceof IpV4Neighbour)) continue;
            c.writeBytes(speaker.localSpeaker().toOctets());
            c.writeBytes(speaker.remoteSpeaker().toOctets());
        }
        int length = c.writerIndex() - iLengthIndex;
        c.setShort(iLengthIndex, (int)((short)(length - 2)));
        return c.writerIndex() - iLenStartIndex;
    }

    public static WideCommunityIpV4Neighbour read(ChannelBuffer c) throws BgpParseException {
        WideCommunityIpV4Neighbour wideCommNeighbour = new WideCommunityIpV4Neighbour();
        if (c.readableBytes() == 0) {
            Validation.validateLen((byte)3, (byte)5, c.readableBytes());
        }
        short length = c.readShort();
        if (c.readableBytes() == 0) {
            return wideCommNeighbour;
        }
        if (c.readableBytes() < length) {
            Validation.validateLen((byte)3, (byte)5, c.readableBytes());
        }
        while (c.readableBytes() > 0) {
            if (c.readableBytes() < 8) {
                Validation.validateLen((byte)3, (byte)5, c.readableBytes());
            }
            IpAddress localSpeaker = IpAddress.valueOf((int)c.readInt());
            IpAddress remoteSpeaker = IpAddress.valueOf((int)c.readInt());
            wideCommNeighbour.add(localSpeaker, remoteSpeaker);
        }
        return wideCommNeighbour;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ipv4Neighbour", this.ipv4Neighbour).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public short getType() {
        return 0;
    }

    private class IpV4Neighbour {
        private IpAddress localSpeaker;
        private IpAddress remoteSpeaker;

        public IpV4Neighbour(IpAddress localSpeaker, IpAddress remoteSpeaker) {
            this.localSpeaker = localSpeaker;
            this.remoteSpeaker = remoteSpeaker;
        }

        public IpAddress localSpeaker() {
            return this.localSpeaker;
        }

        public IpAddress remoteSpeaker() {
            return this.remoteSpeaker;
        }
    }
}

