/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onosproject.bgpio.protocol.IgpRouterId;
import org.onosproject.bgpio.types.BgpValueType;

public class OspfPseudonode
implements IgpRouterId,
BgpValueType {
    public static final short TYPE = 515;
    public static final short LENGTH = 8;
    private final int routerID;
    private final Ip4Address drInterface;

    public OspfPseudonode(int routerID, Ip4Address drInterface) {
        this.routerID = routerID;
        this.drInterface = drInterface;
    }

    public static OspfPseudonode of(int routerID, Ip4Address drInterface) {
        return new OspfPseudonode(routerID, drInterface);
    }

    public int getrouterID() {
        return this.routerID;
    }

    public int hashCode() {
        return Objects.hash(this.routerID, this.drInterface);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OspfPseudonode) {
            OspfPseudonode other = (OspfPseudonode)obj;
            return Objects.equals(this.routerID, other.routerID) && Objects.equals(this.drInterface, other.drInterface);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(515);
        c.writeShort(8);
        c.writeInt(this.routerID);
        c.writeInt(this.drInterface.toInt());
        return c.writerIndex() - iLenStartIndex;
    }

    public static OspfPseudonode read(ChannelBuffer cb) {
        int routerID = cb.readInt();
        Ip4Address drInterface = Ip4Address.valueOf((int)cb.readInt());
        return OspfPseudonode.of(routerID, drInterface);
    }

    @Override
    public short getType() {
        return 515;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        int result = Integer.valueOf(this.routerID).compareTo(((OspfPseudonode)o).routerID);
        if (result != 0) {
            return this.drInterface.compareTo((IpAddress)((OspfPseudonode)o).drInterface);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 515).add("Length", 8).add("RouterID", this.routerID).add("DRInterface", (Object)this.drInterface).toString();
    }
}

