/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.attr.BgpAttrNodeFlagBitTlv;
import org.onosproject.bgpio.types.attr.BgpAttrNodeIsIsAreaId;
import org.onosproject.bgpio.types.attr.BgpAttrNodeMultiTopologyId;
import org.onosproject.bgpio.types.attr.BgpAttrNodeName;
import org.onosproject.bgpio.types.attr.BgpAttrOpaqueNode;
import org.onosproject.bgpio.types.attr.BgpAttrRouterIdV4;
import org.onosproject.bgpio.types.attr.BgpAttrRouterIdV6;
import org.onosproject.bgpio.types.attr.BgpLinkAttrIgpMetric;
import org.onosproject.bgpio.types.attr.BgpLinkAttrIsIsAdminstGrp;
import org.onosproject.bgpio.types.attr.BgpLinkAttrMaxLinkBandwidth;
import org.onosproject.bgpio.types.attr.BgpLinkAttrMplsProtocolMask;
import org.onosproject.bgpio.types.attr.BgpLinkAttrName;
import org.onosproject.bgpio.types.attr.BgpLinkAttrOpaqLnkAttrib;
import org.onosproject.bgpio.types.attr.BgpLinkAttrProtectionType;
import org.onosproject.bgpio.types.attr.BgpLinkAttrSrlg;
import org.onosproject.bgpio.types.attr.BgpLinkAttrTeDefaultMetric;
import org.onosproject.bgpio.types.attr.BgpLinkAttrUnRsrvdLinkBandwidth;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrExtRouteTag;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrIgpFlags;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrMetric;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrOpaqueData;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrOspfFwdAddr;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrRouteTag;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkStateAttributes
implements BgpValueType {
    protected static final Logger log = LoggerFactory.getLogger(LinkStateAttributes.class);
    public static final short ATTR_NODE_MT_TOPOLOGY_ID = 263;
    public static final short ATTR_NODE_FLAG_BITS = 1024;
    public static final short ATTR_NODE_OPAQUE_NODE = 1025;
    public static final short ATTR_NODE_NAME = 1026;
    public static final short ATTR_NODE_ISIS_AREA_ID = 1027;
    public static final short ATTR_NODE_IPV4_LOCAL_ROUTER_ID = 1028;
    public static final short ATTR_NODE_IPV6_LOCAL_ROUTER_ID = 1029;
    public static final short ATTR_LINK_IPV4_REMOTE_ROUTER_ID = 1030;
    public static final short ATTR_LINK_IPV6_REMOTE_ROUTER_ID = 1031;
    public static final short ATTR_LINK_ADMINISTRATIVE_GRPS = 1088;
    public static final short ATTR_LINK_MAX_BANDWIDTH = 1089;
    public static final short ATTR_LINK_MAX_RES_BANDWIDTH = 1090;
    public static final short ATTR_LINK_UNRES_BANDWIDTH = 1091;
    public static final short ATTR_LINK_TE_DEFAULT_METRIC = 1092;
    public static final short ATTR_LINK_PROTECTION_TYPE = 1093;
    public static final short ATTR_LINK_MPLS_PROTOCOL_MASK = 1094;
    public static final short ATTR_LINK_IGP_METRIC = 1095;
    public static final short ATTR_LINK_SHR_RISK_GRP = 1096;
    public static final short ATTR_LINK_OPAQUE_ATTR = 1097;
    public static final short ATTR_LINK_NAME_ATTR = 1098;
    public static final short ATTR_PREFIX_IGP_FLAG = 1152;
    public static final short ATTR_PREFIX_ROUTE_TAG = 1153;
    public static final short ATTR_PREFIX_EXTENDED_TAG = 1154;
    public static final short ATTR_PREFIX_METRIC = 1155;
    public static final short ATTR_PREFIX_OSPF_FWD_ADDR = 1156;
    public static final short ATTR_PREFIX_OPAQUE_ATTR = 1157;
    public static final byte LINKSTATE_ATTRIB_TYPE = 29;
    public static final byte TYPE_AND_LEN = 4;
    private boolean isLinkStateAttribute = false;
    private List<BgpValueType> linkStateAttribList;

    LinkStateAttributes() {
        this.linkStateAttribList = null;
    }

    public LinkStateAttributes(List<BgpValueType> linkStateAttribList) {
        this.linkStateAttribList = linkStateAttribList;
        this.isLinkStateAttribute = true;
    }

    public List<BgpValueType> linkStateAttributes() {
        return this.linkStateAttribList;
    }

    public boolean isLinkStateAttributeSet() {
        return this.isLinkStateAttribute;
    }

    public static LinkStateAttributes read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempBuf = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempBuf.readBytes(len);
        if (!parseFlags.getFirstBit() && parseFlags.getSecondBit() && parseFlags.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        if (cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)2, parseFlags.getLength());
        }
        BgpValueType bgpLSAttrib = null;
        LinkedList<BgpValueType> linkStateAttribList = new LinkedList<BgpValueType>();
        ChannelBuffer tempCb = cb.readBytes(parseFlags.getLength());
        while (tempCb.readableBytes() > 0) {
            short tlvCodePoint = tempCb.readShort();
            switch (tlvCodePoint) {
                case 263: {
                    bgpLSAttrib = BgpAttrNodeMultiTopologyId.read(tempCb);
                    break;
                }
                case 1024: {
                    bgpLSAttrib = BgpAttrNodeFlagBitTlv.read(tempCb);
                    break;
                }
                case 1025: {
                    bgpLSAttrib = BgpAttrOpaqueNode.read(tempCb);
                    break;
                }
                case 1026: {
                    bgpLSAttrib = BgpAttrNodeName.read(tempCb);
                    break;
                }
                case 1027: {
                    bgpLSAttrib = BgpAttrNodeIsIsAreaId.read(tempCb);
                    break;
                }
                case 1028: {
                    bgpLSAttrib = BgpAttrRouterIdV4.read(tempCb, (short)1028);
                    break;
                }
                case 1029: {
                    bgpLSAttrib = BgpAttrRouterIdV6.read(tempCb, (short)1029);
                    break;
                }
                case 1030: {
                    bgpLSAttrib = BgpAttrRouterIdV4.read(tempCb, (short)1030);
                    break;
                }
                case 1031: {
                    bgpLSAttrib = BgpAttrRouterIdV6.read(tempCb, (short)1031);
                    break;
                }
                case 1088: {
                    bgpLSAttrib = BgpLinkAttrIsIsAdminstGrp.read(tempCb);
                    break;
                }
                case 1089: {
                    bgpLSAttrib = BgpLinkAttrMaxLinkBandwidth.read(tempCb, (short)1089);
                    break;
                }
                case 1090: {
                    bgpLSAttrib = BgpLinkAttrMaxLinkBandwidth.read(tempCb, (short)1090);
                    break;
                }
                case 1091: {
                    bgpLSAttrib = BgpLinkAttrUnRsrvdLinkBandwidth.read(tempCb, (short)1091);
                    break;
                }
                case 1092: {
                    bgpLSAttrib = BgpLinkAttrTeDefaultMetric.read(tempCb);
                    break;
                }
                case 1093: {
                    bgpLSAttrib = BgpLinkAttrProtectionType.read(tempCb);
                    break;
                }
                case 1094: {
                    bgpLSAttrib = BgpLinkAttrMplsProtocolMask.read(tempCb);
                    break;
                }
                case 1095: {
                    bgpLSAttrib = BgpLinkAttrIgpMetric.read(tempCb);
                    break;
                }
                case 1096: {
                    bgpLSAttrib = BgpLinkAttrSrlg.read(tempCb);
                    break;
                }
                case 1097: {
                    bgpLSAttrib = BgpLinkAttrOpaqLnkAttrib.read(tempCb);
                    break;
                }
                case 1098: {
                    bgpLSAttrib = BgpLinkAttrName.read(tempCb);
                    break;
                }
                case 1152: {
                    bgpLSAttrib = BgpPrefixAttrIgpFlags.read(tempCb);
                    break;
                }
                case 1153: {
                    bgpLSAttrib = BgpPrefixAttrRouteTag.read(tempCb);
                    break;
                }
                case 1154: {
                    bgpLSAttrib = BgpPrefixAttrExtRouteTag.read(tempCb);
                    break;
                }
                case 1155: {
                    bgpLSAttrib = BgpPrefixAttrMetric.read(tempCb);
                    break;
                }
                case 1156: {
                    bgpLSAttrib = BgpPrefixAttrOspfFwdAddr.read(tempCb);
                    break;
                }
                case 1157: {
                    bgpLSAttrib = BgpPrefixAttrOpaqueData.read(tempCb);
                    break;
                }
                default: {
                    throw new BgpParseException("The Bgp-LS Attribute is not supported : " + tlvCodePoint);
                }
            }
            linkStateAttribList.add(bgpLSAttrib);
        }
        return new LinkStateAttributes(linkStateAttribList);
    }

    @Override
    public short getType() {
        return 29;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("linkStateAttribList", this.linkStateAttribList).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

