/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class IPv4AddressTlv
implements BgpValueType {
    private static final int LENGTH = 4;
    private Ip4Address address;
    private short type;

    public IPv4AddressTlv(Ip4Address address, short type) {
        this.address = (Ip4Address)Preconditions.checkNotNull((Object)address);
        this.type = type;
    }

    public Ip4Address address() {
        return this.address;
    }

    @Override
    public short getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPv4AddressTlv) {
            IPv4AddressTlv other = (IPv4AddressTlv)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.type, other.type);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort((int)this.type);
        cb.writeShort(4);
        cb.writeInt(this.address.toInt());
        return cb.writerIndex() - iLenStartIndex;
    }

    public static IPv4AddressTlv read(ChannelBuffer cb, short type) throws BgpParseException {
        InetAddress ipAddress = Validation.toInetAddress(4, cb);
        if (ipAddress.isMulticastAddress()) {
            throw new BgpParseException(3, 0, null);
        }
        Ip4Address address = Ip4Address.valueOf((InetAddress)ipAddress);
        return IPv4AddressTlv.of(address, type);
    }

    public static IPv4AddressTlv of(Ip4Address address, short type) {
        return new IPv4AddressTlv(address, type);
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.address.compareTo((IpAddress)((IPv4AddressTlv)o).address);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", (int)this.type).add("LENGTH", 4).add("address", (Object)this.address).toString();
    }
}

