/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;

public class BgpFsActionTrafficMarking
implements BgpValueType {
    public static final short TYPE = -32759;
    private byte[] dscpValue;
    public static final byte DSCP_LEN = 6;

    public BgpFsActionTrafficMarking(byte[] dscpValue) {
        this.dscpValue = Arrays.copyOf(dscpValue, dscpValue.length);
    }

    @Override
    public short getType() {
        return -32759;
    }

    public int hashCode() {
        return Arrays.hashCode(this.dscpValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFsActionTrafficMarking) {
            BgpFsActionTrafficMarking other = (BgpFsActionTrafficMarking)obj;
            return Arrays.equals(this.dscpValue, other.dscpValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort(-32759);
        cb.writeBytes(this.dscpValue);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static BgpFsActionTrafficMarking read(ChannelBuffer cb) throws BgpParseException {
        byte[] dscpValue = cb.readBytes(6).array();
        return new BgpFsActionTrafficMarking(dscpValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TYPE", -32759).add("dscpValue", (Object)this.dscpValue).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

