/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;

public class AreaIDTlv
implements BgpValueType {
    public static final short TYPE = 514;
    public static final short LENGTH = 4;
    private final int areaID;

    public AreaIDTlv(int areaID) {
        this.areaID = areaID;
    }

    public static AreaIDTlv of(int areaID) {
        return new AreaIDTlv(areaID);
    }

    public int getAreaID() {
        return this.areaID;
    }

    public int hashCode() {
        return Objects.hash(this.areaID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AreaIDTlv) {
            AreaIDTlv other = (AreaIDTlv)obj;
            return Objects.equals(this.areaID, other.areaID);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(514);
        c.writeShort(4);
        c.writeInt(this.areaID);
        return c.writerIndex() - iLenStartIndex;
    }

    public static AreaIDTlv read(ChannelBuffer cb) {
        return AreaIDTlv.of(cb.readInt());
    }

    @Override
    public short getType() {
        return 514;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return Integer.valueOf(this.areaID).compareTo(((AreaIDTlv)o).areaID);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 514).add("Length", 4).add("Value", this.areaID).toString();
    }
}

