/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.linkstate;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpNodeLSNlri;
import org.onosproject.bgpio.protocol.NlriType;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpNodeLSNlriVer4
implements BgpNodeLSNlri {
    protected static final Logger log = LoggerFactory.getLogger(BgpNodeLSNlriVer4.class);
    public static final int NODE_NLRITYPE = 1;
    public static final int IDENTIFIER_LENGTH = 16;
    private long identifier;
    private byte protocolId;
    private BgpNodeLSIdentifier localNodeDescriptors;
    private RouteDistinguisher routeDistinguisher;
    private boolean isVpn;

    public BgpNodeLSNlriVer4() {
        this.identifier = 0L;
        this.protocolId = 0;
        this.localNodeDescriptors = null;
        this.routeDistinguisher = null;
        this.isVpn = false;
    }

    public BgpNodeLSNlriVer4(long identifier, byte protocolId, BgpNodeLSIdentifier localNodeDescriptors, boolean isVpn, RouteDistinguisher routeDistinguisher) {
        this.identifier = identifier;
        this.protocolId = protocolId;
        this.localNodeDescriptors = localNodeDescriptors;
        this.routeDistinguisher = routeDistinguisher;
        this.isVpn = isVpn;
    }

    public static BgpNodeLSNlriVer4 read(ChannelBuffer cb, short afi, byte safi) throws BgpParseException {
        boolean isVpn = false;
        RouteDistinguisher routeDistinguisher = null;
        if (afi == 16388 && safi == -128) {
            routeDistinguisher = new RouteDistinguisher();
            routeDistinguisher = RouteDistinguisher.read(cb);
            isVpn = true;
        } else {
            isVpn = false;
        }
        byte protocolId = cb.readByte();
        long identifier = cb.readLong();
        log.debug("Parse local node descriptors");
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier();
        localNodeDescriptors = BgpNodeLSIdentifier.parseLocalNodeDescriptors(cb, protocolId);
        return new BgpNodeLSNlriVer4(identifier, protocolId, localNodeDescriptors, isVpn, routeDistinguisher);
    }

    @Override
    public NlriType getNlriType() {
        return NlriType.NODE;
    }

    @Override
    public BgpNodeLSIdentifier getLocalNodeDescriptors() {
        return this.localNodeDescriptors;
    }

    public boolean isVpnPresent() {
        return this.isVpn;
    }

    @Override
    public RouteDistinguisher getRouteDistinguisher() {
        return this.routeDistinguisher;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    public void setNodeLSIdentifier(BgpNodeLSIdentifier localNodeDescriptors) {
        this.localNodeDescriptors = localNodeDescriptors;
    }

    @Override
    public ProtocolType getProtocolId() throws BgpParseException {
        switch (this.protocolId) {
            case 1: {
                return ProtocolType.ISIS_LEVEL_ONE;
            }
            case 2: {
                return ProtocolType.ISIS_LEVEL_TWO;
            }
            case 3: {
                return ProtocolType.OSPF_V2;
            }
            case 4: {
                return ProtocolType.DIRECT;
            }
            case 5: {
                return ProtocolType.STATIC_CONFIGURATION;
            }
            case 6: {
                return ProtocolType.OSPF_V3;
            }
        }
        throw new BgpParseException(3, 0, null);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("protocolId", (int)this.protocolId).add("identifier", this.identifier).add("RouteDistinguisher ", (Object)this.routeDistinguisher).add("localNodeDescriptors", (Object)this.localNodeDescriptors).toString();
    }

    public static enum ProtocolType {
        ISIS_LEVEL_ONE(1),
        ISIS_LEVEL_TWO(2),
        OSPF_V2(3),
        DIRECT(4),
        STATIC_CONFIGURATION(5),
        OSPF_V3(6);

        int value;

        private ProtocolType(int val) {
            this.value = val;
        }

        public byte getType() {
            return (byte)this.value;
        }
    }
}

