/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.evpn;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.MacAddress;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.evpn.BgpEvpnNlriData;
import org.onosproject.bgpio.protocol.evpn.BgpEvpnRouteType;
import org.onosproject.bgpio.types.BgpEvpnEsi;
import org.onosproject.bgpio.types.BgpEvpnLabel;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpEvpnRouteType2Nlri
implements BgpEvpnNlriData {
    public static final short TYPE = 2;
    protected static final Logger log = LoggerFactory.getLogger(BgpEvpnRouteType2Nlri.class);
    public static final short IPV4_ADDRESS_LENGTH = 32;
    public static final short MAC_ADDRESS_LENGTH = 48;
    private RouteDistinguisher rd;
    private BgpEvpnEsi esi;
    private int ethernetTagID;
    private byte macAddressLength;
    private MacAddress macAddress;
    private byte ipAddressLength;
    private InetAddress ipAddress;
    private BgpEvpnLabel mplsLabel1;
    private BgpEvpnLabel mplsLabel2;

    public BgpEvpnRouteType2Nlri() {
        this.rd = null;
        this.esi = null;
        this.ethernetTagID = 0;
        this.macAddressLength = 0;
        this.macAddress = null;
        this.ipAddressLength = 0;
        this.ipAddress = null;
        this.mplsLabel1 = null;
        this.mplsLabel2 = null;
    }

    public BgpEvpnRouteType2Nlri(RouteDistinguisher rd, BgpEvpnEsi esi, int ethernetTagID, MacAddress macAddress, InetAddress ipAddress, BgpEvpnLabel mplsLabel1, BgpEvpnLabel mplsLabel2) {
        this.rd = rd;
        this.esi = esi;
        this.ethernetTagID = ethernetTagID;
        this.macAddressLength = (byte)48;
        this.macAddress = macAddress;
        if (ipAddress != null) {
            this.ipAddressLength = (byte)32;
            this.ipAddress = ipAddress;
        } else {
            this.ipAddressLength = 0;
            this.ipAddress = null;
        }
        this.mplsLabel1 = mplsLabel1;
        this.mplsLabel2 = mplsLabel2;
    }

    public static BgpEvpnRouteType2Nlri read(ChannelBuffer cb) throws BgpParseException {
        if (cb.readableBytes() == 0) {
            return null;
        }
        RouteDistinguisher rd = RouteDistinguisher.read(cb);
        BgpEvpnEsi esi = BgpEvpnEsi.read(cb);
        int ethernetTagID = cb.readInt();
        byte macAddressLength = cb.readByte();
        MacAddress macAddress = Validation.toMacAddress(macAddressLength / 8, cb);
        byte ipAddressLength = cb.readByte();
        InetAddress ipAddress = null;
        if (ipAddressLength > 0) {
            ipAddress = Validation.toInetAddress(ipAddressLength / 8, cb);
        }
        BgpEvpnLabel mplsLabel1 = BgpEvpnLabel.read(cb);
        BgpEvpnLabel mplsLabel2 = null;
        if (cb.readableBytes() > 0) {
            mplsLabel2 = BgpEvpnLabel.read(cb);
        }
        return new BgpEvpnRouteType2Nlri(rd, esi, ethernetTagID, macAddress, ipAddress, mplsLabel1, mplsLabel2);
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeLong(this.rd.getRouteDistinguisher());
        this.esi.write(cb);
        cb.writeInt(this.ethernetTagID);
        cb.writeByte((int)this.macAddressLength);
        cb.writeBytes(this.macAddress.toBytes());
        cb.writeByte((int)this.ipAddressLength);
        if (this.ipAddressLength > 0) {
            cb.writeBytes(this.ipAddress.getAddress());
        }
        this.mplsLabel1.write(cb);
        if (this.mplsLabel2 != null) {
            this.mplsLabel2.write(cb);
        }
        return cb.writerIndex() - iLenStartIndex;
    }

    public RouteDistinguisher getRouteDistinguisher() {
        return this.rd;
    }

    public BgpEvpnEsi getEthernetSegmentidentifier() {
        return this.esi;
    }

    public int getEthernetTagID() {
        return this.ethernetTagID;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public BgpEvpnLabel getMplsLable1() {
        return this.mplsLabel1;
    }

    public BgpEvpnLabel getMplsLable2() {
        return this.mplsLabel2;
    }

    public void setRouteDistinguisher(RouteDistinguisher rd) {
        this.rd = rd;
    }

    public void setEthernetSegmentidentifier(BgpEvpnEsi esi) {
        this.esi = esi;
    }

    public void setEthernetTagID(int ethernetTagID) {
        this.ethernetTagID = ethernetTagID;
    }

    public void setMacAddress(MacAddress macAddress) {
        this.macAddress = macAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setMplsLable1(BgpEvpnLabel mplsLabel1) {
        this.mplsLabel1 = mplsLabel1;
    }

    public void setMplsLable2(BgpEvpnLabel mplsLabel2) {
        this.mplsLabel2 = mplsLabel2;
    }

    @Override
    public BgpEvpnRouteType getType() {
        return BgpEvpnRouteType.MAC_IP_ADVERTISEMENT;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("rd ", (Object)this.rd).add("esi", (Object)this.esi).add("ethernetTagID", this.ethernetTagID).add("macAddressLength", (int)this.macAddressLength).add("macAddress ", (Object)this.macAddress).add("ipAddressLength", (int)this.ipAddressLength).add("ipAddress", (Object)this.ipAddress).add("mplsLabel1 ", (Object)this.mplsLabel1).add("mplsLabel2", (Object)this.mplsLabel2).toString();
    }
}

