/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.evpn;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpEvpnNlri;
import org.onosproject.bgpio.protocol.evpn.BgpEvpnNlriData;
import org.onosproject.bgpio.protocol.evpn.BgpEvpnRouteType;
import org.onosproject.bgpio.protocol.evpn.BgpEvpnRouteType2Nlri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpEvpnNlriImpl
implements BgpEvpnNlri {
    protected static final Logger log = LoggerFactory.getLogger(BgpEvpnNlriImpl.class);
    public static final short TYPE_AND_LEN = 2;
    private byte routeType;
    private BgpEvpnNlriData routeTypeSpec;

    public BgpEvpnNlriImpl() {
        this.routeType = (byte)2;
        this.routeTypeSpec = null;
    }

    public BgpEvpnNlriImpl(byte routeType, BgpEvpnNlriData routeTypeSpefic) {
        this.routeType = routeType;
        this.routeTypeSpec = routeTypeSpefic;
    }

    public static BgpEvpnNlriImpl read(ChannelBuffer cb) throws BgpParseException {
        BgpEvpnRouteType2Nlri routeNlri = null;
        if (cb.readableBytes() > 0) {
            ChannelBuffer tempBuf = cb.copy();
            byte type = cb.readByte();
            byte length = cb.readByte();
            if (cb.readableBytes() < length) {
                throw new BgpParseException(3, 9, tempBuf.readBytes(cb.readableBytes() + 2));
            }
            ChannelBuffer tempCb = cb.readBytes((int)length);
            switch (type) {
                case 2: {
                    routeNlri = BgpEvpnRouteType2Nlri.read(tempCb);
                    break;
                }
                default: {
                    log.info("Discarding, EVPN route type {}", (Object)type);
                    throw new BgpParseException(3, 3, null);
                }
            }
            return new BgpEvpnNlriImpl(type, routeNlri);
        }
        return new BgpEvpnNlriImpl();
    }

    @Override
    public BgpEvpnNlriData getNlri() {
        return this.routeTypeSpec;
    }

    @Override
    public BgpEvpnRouteType getRouteType() {
        switch (this.routeType) {
            case 1: {
                return BgpEvpnRouteType.ETHERNET_AUTO_DISCOVERY;
            }
            case 2: {
                return BgpEvpnRouteType.MAC_IP_ADVERTISEMENT;
            }
            case 3: {
                return BgpEvpnRouteType.INCLUSIVE_MULTICASE_ETHERNET;
            }
            case 4: {
                return BgpEvpnRouteType.ETHERNET_SEGMENT;
            }
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("routeType", (int)this.routeType).add("routeTypeSpefic ", (Object)this.routeTypeSpec).toString();
    }

    @Override
    public short getType() {
        return this.routeType;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte((int)this.routeType);
        int iSpecStartIndex = cb.writerIndex();
        cb.writeByte(0);
        switch (this.routeType) {
            case 2: {
                ((BgpEvpnRouteType2Nlri)this.routeTypeSpec).write(cb);
                break;
            }
        }
        cb.setByte(iSpecStartIndex, (int)((short)(cb.writerIndex() - iSpecStartIndex + 1)));
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

