/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.topK;

import com.clearspring.analytics.stream.Counter;
import com.clearspring.analytics.stream.StreamSummary;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StreamSummaryContainer {
    private static final int MAX_CAPACITY = 100000;
    private static final Log log = LogFactory.getLog(StreamSummaryContainer.class);
    private final String cacheName;
    private final String address;
    private final AtomicBoolean flushing;
    private final EnumMap<Stat, TopKeyWrapper> topKeyWrapper;
    private volatile int capacity = 1000;
    private volatile boolean enabled = false;
    private volatile boolean reset = false;

    public StreamSummaryContainer(String cacheName, String address) {
        this.cacheName = cacheName;
        this.address = address;
        this.flushing = new AtomicBoolean(false);
        this.topKeyWrapper = new EnumMap(Stat.class);
        for (Stat stat : Stat.values()) {
            this.topKeyWrapper.put(stat, new TopKeyWrapper());
        }
        this.resetAll();
    }

    public static StreamSummaryContainer getOrCreateStreamLibContainer(Cache cache) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        StreamSummaryContainer streamLibContainer = (StreamSummaryContainer)componentRegistry.getComponent(StreamSummaryContainer.class);
        if (streamLibContainer == null) {
            String cacheName = cache.getName();
            String address = String.valueOf(cache.getCacheManager().getAddress());
            componentRegistry.registerComponent((Object)new StreamSummaryContainer(cacheName, address), StreamSummaryContainer.class);
        }
        return (StreamSummaryContainer)componentRegistry.getComponent(StreamSummaryContainer.class);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (!this.enabled && enabled) {
            this.resetAll();
        } else if (!enabled) {
            this.resetAll();
        }
        this.enabled = enabled;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity <= 0 ? 1 : Math.min(capacity, 100000);
    }

    public void addGet(Object key, boolean remote) {
        if (!this.isEnabled()) {
            return;
        }
        this.syncOffer(remote ? Stat.REMOTE_GET : Stat.LOCAL_GET, key);
    }

    public void addPut(Object key, boolean remote) {
        if (!this.isEnabled()) {
            return;
        }
        this.syncOffer(remote ? Stat.REMOTE_PUT : Stat.LOCAL_PUT, key);
    }

    public void addLockInformation(Object key, boolean contention, boolean failLock) {
        if (!this.isEnabled()) {
            return;
        }
        this.syncOffer(Stat.MOST_LOCKED_KEYS, key);
        if (contention) {
            this.syncOffer(Stat.MOST_CONTENDED_KEYS, key);
        }
        if (failLock) {
            this.syncOffer(Stat.MOST_FAILED_KEYS, key);
        }
    }

    public void addWriteSkewFailed(Object key) {
        this.syncOffer(Stat.MOST_WRITE_SKEW_FAILED_KEYS, key);
    }

    public Map<Object, Long> getTopKFrom(Stat stat) {
        return this.getTopKFrom(stat, this.capacity);
    }

    public Map<Object, Long> getTopKFrom(Stat stat, int topK) {
        this.tryFlushAll();
        return this.topKeyWrapper.get((Object)stat).topK(topK);
    }

    public Map<String, Long> getTopKFromAsKeyString(Stat stat) {
        return this.getTopKFromAsKeyString(stat, this.capacity);
    }

    public Map<String, Long> getTopKFromAsKeyString(Stat stat, int topK) {
        this.tryFlushAll();
        return this.topKeyWrapper.get((Object)stat).topKAsString(topK);
    }

    public final void resetAll() {
        this.reset = true;
        this.tryFlushAll();
    }

    public final void tryFlushAll() {
        if (this.flushing.compareAndSet(false, true)) {
            if (this.reset) {
                for (Stat stat : Stat.values()) {
                    this.topKeyWrapper.get((Object)stat).reset(this, this.capacity);
                }
                this.reset = false;
            } else {
                for (Stat stat : Stat.values()) {
                    this.topKeyWrapper.get((Object)stat).flush();
                }
            }
            this.flushing.set(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSummaryContainer that = (StreamSummaryContainer)o;
        return !(this.address == null ? that.address != null : !this.address.equals(that.address)) && !(this.cacheName == null ? that.cacheName != null : !this.cacheName.equals(that.cacheName));
    }

    public int hashCode() {
        int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StreamSummaryContainer{cacheName='" + this.cacheName + '\'' + ", address='" + this.address + '\'' + '}';
    }

    private StreamSummary<Object> createNewStreamSummary(int customCapacity) {
        return new StreamSummary(Math.min(100000, customCapacity));
    }

    private void syncOffer(Stat stat, Object key) {
        if (log.isTraceEnabled()) {
            log.tracef("Offer key=%s to stat=%s in %s", key, (Object)stat, (Object)this);
        }
        this.topKeyWrapper.get((Object)stat).offer(key);
        this.tryFlushAll();
    }

    private class TopKeyWrapper {
        private final BlockingQueue<Object> pendingOffers = new LinkedBlockingQueue<Object>();
        private volatile StreamSummary<Object> streamSummary;

        private TopKeyWrapper() {
        }

        private void offer(Object element) {
            this.pendingOffers.add(element);
        }

        private void reset(StreamSummaryContainer container, int capacity) {
            this.pendingOffers.clear();
            this.streamSummary = container.createNewStreamSummary(capacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush() {
            ArrayList keys = new ArrayList();
            this.pendingOffers.drainTo(keys);
            StreamSummary<Object> summary = this.streamSummary;
            for (Object key : keys) {
                TopKeyWrapper topKeyWrapper = this;
                synchronized (topKeyWrapper) {
                    summary.offer(key);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Object, Long> topK(int k) {
            List counterList;
            TopKeyWrapper topKeyWrapper = this;
            synchronized (topKeyWrapper) {
                counterList = this.streamSummary.topK(k);
            }
            LinkedHashMap<Object, Long> map = new LinkedHashMap<Object, Long>();
            for (Counter counter : counterList) {
                map.put(counter.getItem(), counter.getCount());
            }
            if (log.isTraceEnabled()) {
                log.tracef(this + " top-k is " + map, new Object[0]);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Long> topKAsString(int k) {
            List counterList;
            TopKeyWrapper topKeyWrapper = this;
            synchronized (topKeyWrapper) {
                counterList = this.streamSummary.topK(k);
            }
            LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
            for (Counter counter : counterList) {
                map.put(String.valueOf(counter.getItem()), counter.getCount());
            }
            return map;
        }
    }

    public static enum Stat {
        REMOTE_GET,
        LOCAL_GET,
        REMOTE_PUT,
        LOCAL_PUT,
        MOST_LOCKED_KEYS,
        MOST_CONTENDED_KEYS,
        MOST_FAILED_KEYS,
        MOST_WRITE_SKEW_FAILED_KEYS;

    }
}

