/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.percentiles;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ReservoirSampler {
    private static final int DEFAULT_NUM_SPOTS = 100;
    private final AtomicInteger index;
    private final Random random;
    private double[] reservoir;

    public ReservoirSampler() {
        this(100);
    }

    public ReservoirSampler(int numSpots) {
        this.reservoir = this.createArray(numSpots);
        this.index = new AtomicInteger(0);
        this.random = new Random(System.nanoTime());
    }

    public final synchronized void insertSample(double sample) {
        int i = this.index.getAndIncrement();
        if (i < this.reservoir.length) {
            this.reservoir[i] = sample;
        } else {
            int randGenerated = this.random.nextInt(i + 2);
            if (randGenerated < this.reservoir.length) {
                this.reservoir[randGenerated] = sample;
            }
        }
    }

    public final synchronized double getKPercentile(int k) throws IllegalArgumentException {
        if (k < 0 || k > 100) {
            throw new IllegalArgumentException(k + " should be between 0 and 100 exclusive");
        }
        double[] copy = this.createArray(this.reservoir.length);
        System.arraycopy(this.reservoir, 0, copy, 0, this.reservoir.length);
        Arrays.sort(copy);
        return copy[this.getIndex(k)];
    }

    public final synchronized void reset() {
        this.index.set(0);
        this.reservoir = this.createArray(this.reservoir.length);
    }

    private int getIndex(int k) {
        return this.reservoir.length * (k - 1) / 100;
    }

    private double[] createArray(int size) {
        return new double[size];
    }
}

