/*
 * Decompiled with CFR 0.152.
 */
package com.tspoon.traceur;

import com.tspoon.traceur.Traceur;
import com.tspoon.traceur.TraceurConfig;
import java.util.ArrayList;

public class TraceurException
extends RuntimeException {
    private final boolean shouldFilterStackTraces;
    private final Traceur.LogLevel logLevel;

    public static TraceurException create() {
        TraceurConfig config = Traceur.getConfig();
        return new TraceurException(config.shouldFilterStackTraces(), config.getLogLevel());
    }

    TraceurException(boolean shouldFilterStackTraces, Traceur.LogLevel logLevel) {
        super("Debug Exception generated at call site");
        this.shouldFilterStackTraces = shouldFilterStackTraces;
        this.logLevel = logLevel;
        this.setStackTrace(this.createStackTrace());
    }

    public Throwable appendTo(Throwable throwable) {
        Throwable t = throwable;
        while (t.getCause() != null) {
            if ((t = t.getCause()) == this) {
                return throwable;
            }
            if (this.logLevel != Traceur.LogLevel.SHOW_ONLY_FIRST || !(t instanceof TraceurException)) continue;
            return throwable;
        }
        t.initCause(this);
        return throwable;
    }

    private StackTraceElement[] createStackTrace() {
        StackTraceElement[] realStackTrace = Thread.currentThread().getStackTrace();
        if (!this.shouldFilterStackTraces) {
            return realStackTrace;
        }
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>(realStackTrace.length);
        for (StackTraceElement element : realStackTrace) {
            if (!this.filterLine(element)) continue;
            filtered.add(element);
        }
        return filtered.toArray(new StackTraceElement[filtered.size()]);
    }

    private boolean filterLine(StackTraceElement element) {
        String className = element.getClassName();
        return !className.contains(".Traceur") && !className.contains("OnAssembly") && !className.endsWith(".RxJavaPlugins");
    }
}

