/*
 * Decompiled with CFR 0.152.
 */
package com.tspoon.traceur;

import com.tspoon.traceur.CompletableOnAssembly;
import com.tspoon.traceur.CompletableOnAssemblyCallable;
import com.tspoon.traceur.CompletableOnAssemblyScalarCallable;
import com.tspoon.traceur.FlowableOnAssembly;
import com.tspoon.traceur.FlowableOnAssemblyCallable;
import com.tspoon.traceur.FlowableOnAssemblyConnectable;
import com.tspoon.traceur.FlowableOnAssemblyScalarCallable;
import com.tspoon.traceur.MaybeOnAssembly;
import com.tspoon.traceur.MaybeOnAssemblyCallable;
import com.tspoon.traceur.MaybeOnAssemblyScalarCallable;
import com.tspoon.traceur.ObservableOnAssembly;
import com.tspoon.traceur.ObservableOnAssemblyCallable;
import com.tspoon.traceur.ObservableOnAssemblyConnectable;
import com.tspoon.traceur.ObservableOnAssemblyScalarCallable;
import com.tspoon.traceur.ParallelFlowableOnAssembly;
import com.tspoon.traceur.SingleOnAssembly;
import com.tspoon.traceur.SingleOnAssemblyCallable;
import com.tspoon.traceur.SingleOnAssemblyScalarCallable;
import com.tspoon.traceur.TraceurConfig;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.ScalarCallable;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public class Traceur {
    private static TraceurConfig config;

    private Traceur() {
        throw new IllegalStateException("No instances!");
    }

    public static void enableLogging() {
        Traceur.enableLogging(new TraceurConfig(true));
    }

    public static synchronized void enableLogging(TraceurConfig config) {
        Traceur.config = config;
        RxJavaPlugins.setOnFlowableAssembly((Function)new Function<Flowable, Flowable>(){

            public Flowable apply(Flowable f) throws Exception {
                if (f instanceof Callable) {
                    if (f instanceof ScalarCallable) {
                        return new FlowableOnAssemblyScalarCallable(f);
                    }
                    return new FlowableOnAssemblyCallable(f);
                }
                return new FlowableOnAssembly(f);
            }
        });
        RxJavaPlugins.setOnConnectableFlowableAssembly((Function)new Function<ConnectableFlowable, ConnectableFlowable>(){

            public ConnectableFlowable apply(ConnectableFlowable f) throws Exception {
                return new FlowableOnAssemblyConnectable(f);
            }
        });
        RxJavaPlugins.setOnObservableAssembly((Function)new Function<Observable, Observable>(){

            public Observable apply(Observable f) throws Exception {
                if (f instanceof Callable) {
                    if (f instanceof ScalarCallable) {
                        return new ObservableOnAssemblyScalarCallable(f);
                    }
                    return new ObservableOnAssemblyCallable(f);
                }
                return new ObservableOnAssembly(f);
            }
        });
        RxJavaPlugins.setOnConnectableObservableAssembly((Function)new Function<ConnectableObservable, ConnectableObservable>(){

            public ConnectableObservable apply(ConnectableObservable f) throws Exception {
                return new ObservableOnAssemblyConnectable(f);
            }
        });
        RxJavaPlugins.setOnSingleAssembly((Function)new Function<Single, Single>(){

            public Single apply(Single f) throws Exception {
                if (f instanceof Callable) {
                    if (f instanceof ScalarCallable) {
                        return new SingleOnAssemblyScalarCallable(f);
                    }
                    return new SingleOnAssemblyCallable(f);
                }
                return new SingleOnAssembly(f);
            }
        });
        RxJavaPlugins.setOnCompletableAssembly((Function)new Function<Completable, Completable>(){

            public Completable apply(Completable f) throws Exception {
                if (f instanceof Callable) {
                    if (f instanceof ScalarCallable) {
                        return new CompletableOnAssemblyScalarCallable((CompletableSource)f);
                    }
                    return new CompletableOnAssemblyCallable((CompletableSource)f);
                }
                return new CompletableOnAssembly((CompletableSource)f);
            }
        });
        RxJavaPlugins.setOnMaybeAssembly((Function)new Function<Maybe, Maybe>(){

            public Maybe apply(Maybe f) throws Exception {
                if (f instanceof Callable) {
                    if (f instanceof ScalarCallable) {
                        return new MaybeOnAssemblyScalarCallable(f);
                    }
                    return new MaybeOnAssemblyCallable(f);
                }
                return new MaybeOnAssembly(f);
            }
        });
        RxJavaPlugins.setOnParallelAssembly((Function)new Function<ParallelFlowable, ParallelFlowable>(){

            public ParallelFlowable apply(ParallelFlowable t) throws Exception {
                return new ParallelFlowableOnAssembly(t);
            }
        });
    }

    public static synchronized void disableLogging() {
        RxJavaPlugins.setOnCompletableAssembly(null);
        RxJavaPlugins.setOnSingleAssembly(null);
        RxJavaPlugins.setOnMaybeAssembly(null);
        RxJavaPlugins.setOnObservableAssembly(null);
        RxJavaPlugins.setOnFlowableAssembly(null);
        RxJavaPlugins.setOnConnectableObservableAssembly(null);
        RxJavaPlugins.setOnConnectableFlowableAssembly(null);
        RxJavaPlugins.setOnParallelAssembly(null);
        config = null;
    }

    public static TraceurConfig getConfig() {
        return config;
    }

    public static enum LogLevel {
        SHOW_ALL,
        SHOW_ONLY_FIRST;

    }
}

